package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝“我的家”相关业务通知
 *
 * @author auto create
 * @since 1.0, 2020-02-25 15:39:21
 */
public class AlipayUserFamilyNoticeSendModel extends AlipayObject {

	private static final long serialVersionUID = 1839197393654971843L;

	/**
	 * 用户行为，由我的家为外部业务方约定，标识业务场景中用户行为
	 */
	@ApiField("action")
	private String action;

	/**
	 * 家庭业务场景码，由我的家分配给外部业务方标识业务场景。
	 */
	@ApiField("biz_code")
	private String bizCode;

	/**
	 * 比如某种业务标准外部订单号,比如交易外部订单号，代表商户端自己订单号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getAction() {
		return this.action;
	}
	public void setAction(String action) {
		this.action = action;
	}

	public String getBizCode() {
		return this.bizCode;
	}
	public void setBizCode(String bizCode) {
		this.bizCode = bizCode;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
