package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 还款账单修改
 *
 * @author auto create
 * @since 1.0, 2020-03-11 17:34:43
 */
public class AlipayTradeRepaybillModifyModel extends AlipayObject {

	private static final long serialVersionUID = 1113443869434835342L;

	/**
	 * 要修改的目标相对金额； 如果要在原先的金额上增加则使用正数，要在原来的基础上减少则使用负数
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 支付宝账单号
	 */
	@ApiField("bill_no")
	private String billNo;

	/**
	 * 要修改的账单状态
	 */
	@ApiField("bill_status")
	private String billStatus;

	/**
	 * 要修改的操作类型 
MODIFY_BILL_AMOUNT 
MODIFY_BILL_OVERDUE_AMOUNT 
MODIFY_BILL_STATUS
	 */
	@ApiField("operation_type")
	private String operationType;

	/**
	 * 本次修改请求的请求号，用于做幂等控制
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getBillNo() {
		return this.billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}

	public String getBillStatus() {
		return this.billStatus;
	}
	public void setBillStatus(String billStatus) {
		this.billStatus = billStatus;
	}

	public String getOperationType() {
		return this.operationType;
	}
	public void setOperationType(String operationType) {
		this.operationType = operationType;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

}
