package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 业务订单入账确认
 *
 * @author auto create
 * @since 1.0, 2020-03-11 17:35:33
 */
public class AlipayTradeRepaybillBillinConfirmModel extends AlipayObject {

	private static final long serialVersionUID = 5822464551125655836L;

	/**
	 * 本次业务订单入账的金额，精确到小数点后两位，取值范围[0.01,100000000]
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 账单产品类型，标识业务用，具体值支付宝根据业务接入场景进行分配。
	 */
	@ApiField("bill_product")
	private String billProduct;

	/**
	 * 本次同步账单的交易信息，传入交易号trade_no
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 外部生成的账单号，用于控制账单的幂等，同一批次的业务订单账单号为同一个
	 */
	@ApiField("out_bill_no")
	private String outBillNo;

	/**
	 * 外部请求号,唯一标识一次请求
	 */
	@ApiField("out_request_no")
	private String outRequestNo;

	/**
	 * 账单归属主体，蚂蚁统一会员id
	 */
	@ApiField("user_id")
	private String userId;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getBillProduct() {
		return this.billProduct;
	}
	public void setBillProduct(String billProduct) {
		this.billProduct = billProduct;
	}

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getOutBillNo() {
		return this.outBillNo;
	}
	public void setOutBillNo(String outBillNo) {
		this.outBillNo = outBillNo;
	}

	public String getOutRequestNo() {
		return this.outRequestNo;
	}
	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
