package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 大额无限付产品个人解约接口
 *
 * @author auto create
 * @since 1.0, 2020-04-20 17:04:07
 */
public class AlipayTradeLargeinfiniteProductUnsignModel extends AlipayObject {

	private static final long serialVersionUID = 1829511524577786635L;

	/**
	 * 支付宝协议号，支付宝系统中用以唯一标识用户签约记录的编号
	 */
	@ApiField("agreement_no")
	private String agreementNo;

	/**
	 * 用户的支付宝id
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 无限付接入的业务场景，由支付宝定义
	 */
	@ApiField("biz_type")
	private String bizType;

	public String getAgreementNo() {
		return this.agreementNo;
	}
	public void setAgreementNo(String agreementNo) {
		this.agreementNo = agreementNo;
	}

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

}
