package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 资金记账明细查询
 *
 * @author auto create
 * @since 1.0, 2020-03-11 10:08:13
 */
public class AlipayFundAccountbookBillQueryModel extends AlipayObject {

	private static final long serialVersionUID = 7852882386951648553L;

	/**
	 * 记账账簿id
	 */
	@ApiField("account_book_id")
	private String accountBookId;

	/**
	 * 开始时间
	 */
	@ApiField("begin_time")
	private String beginTime;

	/**
	 * 记账账簿的产品码
	 */
	@ApiField("booking_product_code")
	private String bookingProductCode;

	/**
	 * 记账账簿的场景码
	 */
	@ApiField("booking_scene_code")
	private String bookingSceneCode;

	/**
	 * 结束时间
	 */
	@ApiField("end_time")
	private String endTime;

	/**
	 * JSON格式，传递业务扩展参数，使用前请与支付宝工程师联系！
	 */
	@ApiField("ext_info")
	private String extInfo;

	/**
	 * 查询页码，必须大于0
	 */
	@ApiField("page_num")
	private String pageNum;

	/**
	 * 分页大小，每页条目数需满足0< page_size < 100
	 */
	@ApiField("page_size")
	private Long pageSize;

	public String getAccountBookId() {
		return this.accountBookId;
	}
	public void setAccountBookId(String accountBookId) {
		this.accountBookId = accountBookId;
	}

	public String getBeginTime() {
		return this.beginTime;
	}
	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getBookingProductCode() {
		return this.bookingProductCode;
	}
	public void setBookingProductCode(String bookingProductCode) {
		this.bookingProductCode = bookingProductCode;
	}

	public String getBookingSceneCode() {
		return this.bookingSceneCode;
	}
	public void setBookingSceneCode(String bookingSceneCode) {
		this.bookingSceneCode = bookingSceneCode;
	}

	public String getEndTime() {
		return this.endTime;
	}
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getExtInfo() {
		return this.extInfo;
	}
	public void setExtInfo(String extInfo) {
		this.extInfo = extInfo;
	}

	public String getPageNum() {
		return this.pageNum;
	}
	public void setPageNum(String pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

}
