package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 创建质量诊断工单
 *
 * @author auto create
 * @since 1.0, 2020-02-03 18:04:17
 */
public class AlipayEbppAutodetectOrderCreateModel extends AlipayObject {

	private static final long serialVersionUID = 4689875147844944416L;

	/**
	 * 应用id:
1）小程序必须传appId.
 2）H5取H5应用的appId,如果没有appId,则和dataFromType一样.
	 */
	@ApiField("appid")
	private String appid;

	/**
	 * 业务类型
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 数据来源（一般为系统名称）. 如mservicesinspect.
	 */
	@ApiField("data_from_type")
	private String dataFromType;

	/**
	 * 每次调用,业务方要确保唯一,否则获取诊断结果会出现不可预测情况.
1）如果是蚂蚁流里面调用,可以传蚂蚁流id,如antprocess_44376_10000340897;
2）如果在CI里面发起,传pipeline id;
3）如果没有业务含义,可以传UUID.
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/**
	 * partnerId 服务商pid:
1）小程序必须服务商id.
2）H5没有服务商id,则和dataFromType一样.
	 */
	@ApiField("partner_id")
	private String partnerId;

	/**
	 * 检测实体列表。元素个数不能超过10个
	 */
	@ApiListField("service_info_list")
	@ApiField("detect_task_service")
	private List<DetectTaskService> serviceInfoList;

	public String getAppid() {
		return this.appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getDataFromType() {
		return this.dataFromType;
	}
	public void setDataFromType(String dataFromType) {
		this.dataFromType = dataFromType;
	}

	public String getOutBizNo() {
		return this.outBizNo;
	}
	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}

	public String getPartnerId() {
		return this.partnerId;
	}
	public void setPartnerId(String partnerId) {
		this.partnerId = partnerId;
	}

	public List<DetectTaskService> getServiceInfoList() {
		return this.serviceInfoList;
	}
	public void setServiceInfoList(List<DetectTaskService> serviceInfoList) {
		this.serviceInfoList = serviceInfoList;
	}

}
