package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 大出行智能平台-轮班任务-创建
 *
 * @author auto create
 * @since 1.0, 2020-03-12 20:23:19
 */
public class AlipayCommerceTransportWorkshiftTaskCreateModel extends AlipayObject {

	private static final long serialVersionUID = 7526221367768289925L;

	/**
	 * 算法配置，json格式，由双方约定取值
	 */
	@ApiField("algo_config")
	private String algoConfig;

	/**
	 * 城市代码
	 */
	@ApiField("city_code")
	private String cityCode;

	/**
	 * 扩展参数，json格式，由双方约定取值
	 */
	@ApiField("ext_param")
	private String extParam;

	/**
	 * 期望的优化目标，支持一次性查询多个优化目标，英文半角逗号分隔
	 */
	@ApiField("optimize_targets")
	private String optimizeTargets;

	/**
	 * 请求ID，唯一标识一次请求，由调用方自行确保唯一性
	 */
	@ApiField("request_id")
	private String requestId;

	/**
	 * 服务任务名称
	 */
	@ApiField("service_task_name")
	private String serviceTaskName;

	/**
	 * 线路信息列表，单次请求只支持同一条线路，支持同时计算该线路的上行+下行
	 */
	@ApiListField("time_table_line_info_list")
	@ApiField("time_table_line_info")
	private List<TimeTableLineInfo> timeTableLineInfoList;

	/**
	 * 公交业主ID
	 */
	@ApiField("traffic_owner_id")
	private String trafficOwnerId;

	public String getAlgoConfig() {
		return this.algoConfig;
	}
	public void setAlgoConfig(String algoConfig) {
		this.algoConfig = algoConfig;
	}

	public String getCityCode() {
		return this.cityCode;
	}
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}

	public String getExtParam() {
		return this.extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}

	public String getOptimizeTargets() {
		return this.optimizeTargets;
	}
	public void setOptimizeTargets(String optimizeTargets) {
		this.optimizeTargets = optimizeTargets;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getServiceTaskName() {
		return this.serviceTaskName;
	}
	public void setServiceTaskName(String serviceTaskName) {
		this.serviceTaskName = serviceTaskName;
	}

	public List<TimeTableLineInfo> getTimeTableLineInfoList() {
		return this.timeTableLineInfoList;
	}
	public void setTimeTableLineInfoList(List<TimeTableLineInfo> timeTableLineInfoList) {
		this.timeTableLineInfoList = timeTableLineInfoList;
	}

	public String getTrafficOwnerId() {
		return this.trafficOwnerId;
	}
	public void setTrafficOwnerId(String trafficOwnerId) {
		this.trafficOwnerId = trafficOwnerId;
	}

}
