package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 虚拟卡覆盖查询
 *
 * @author auto create
 * @since 1.0, 2020-01-21 10:40:06
 */
public class AlipayCommerceTransportVirtualcardCoverageQueryModel extends AlipayObject {

	private static final long serialVersionUID = 7616197333275332735L;

	/**
	 * 当前位置区县码，高德标准。例如330102表示上城区。
	 */
	@ApiField("district_code")
	private String districtCode;

	/**
	 * 纬度。火星坐标系。
	 */
	@ApiField("latitude")
	private String latitude;

	/**
	 * 经度。火星坐标系
	 */
	@ApiField("longitude")
	private String longitude;

	/**
	 * 场景码。交通出行场景取值为TRANSIT
	 */
	@ApiField("scene_code")
	private String sceneCode;

	/**
	 * 子场景码。场景码为TRANSIT时，此处填高德城市国标码，例如330100表示杭州市国标码。
	 */
	@ApiField("sub_scene_code")
	private String subSceneCode;

	public String getDistrictCode() {
		return this.districtCode;
	}
	public void setDistrictCode(String districtCode) {
		this.districtCode = districtCode;
	}

	public String getLatitude() {
		return this.latitude;
	}
	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLongitude() {
		return this.longitude;
	}
	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getSceneCode() {
		return this.sceneCode;
	}
	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public String getSubSceneCode() {
		return this.subSceneCode;
	}
	public void setSubSceneCode(String subSceneCode) {
		this.subSceneCode = subSceneCode;
	}

}
