package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 大出行智能平台-单程时间-查询
 *
 * @author auto create
 * @since 1.0, 2020-03-12 20:22:43
 */
public class AlipayCommerceTransportSingletripDurationQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3693556467911646456L;

	/**
	 * 聚合方式（MIN、MAX、MEAN、PERT_95）
	 */
	@ApiField("aggregate_type")
	private String aggregateType;

	/**
	 * 算法配置，json格式，由双方约定取值
	 */
	@ApiField("algo_config")
	private String algoConfig;

	/**
	 * 城市代码
	 */
	@ApiField("city_code")
	private String cityCode;

	/**
	 * 扩展参数，json格式，由双方约定取值
	 */
	@ApiField("ext_param")
	private String extParam;

	/**
	 * 请求ID，唯一标识一次请求，由调用方自行确保唯一性
	 */
	@ApiField("request_id")
	private String requestId;

	/**
	 * 聚合时间粒度（单位：分钟）
	 */
	@ApiField("time_span")
	private Long timeSpan;

	/**
	 * 公交业主ID
	 */
	@ApiField("traffic_owner_id")
	private String trafficOwnerId;

	public String getAggregateType() {
		return this.aggregateType;
	}
	public void setAggregateType(String aggregateType) {
		this.aggregateType = aggregateType;
	}

	public String getAlgoConfig() {
		return this.algoConfig;
	}
	public void setAlgoConfig(String algoConfig) {
		this.algoConfig = algoConfig;
	}

	public String getCityCode() {
		return this.cityCode;
	}
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}

	public String getExtParam() {
		return this.extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public Long getTimeSpan() {
		return this.timeSpan;
	}
	public void setTimeSpan(Long timeSpan) {
		this.timeSpan = timeSpan;
	}

	public String getTrafficOwnerId() {
		return this.trafficOwnerId;
	}
	public void setTrafficOwnerId(String trafficOwnerId) {
		this.trafficOwnerId = trafficOwnerId;
	}

}
