package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 大出行智能-客流分析任务-创建
 *
 * @author auto create
 * @since 1.0, 2020-04-21 16:55:28
 */
public class AlipayCommerceTransportIntelligentizeOdanalysisCreateModel extends AlipayObject {

	private static final long serialVersionUID = 1884195815999847658L;

	/**
	 * 算法配置，json格式，由双方约定取值
	 */
	@ApiField("algo_config")
	private String algoConfig;

	/**
	 * 城市代码
	 */
	@ApiField("city_code")
	private String cityCode;

	/**
	 * 公交企业ID
	 */
	@ApiField("corp_id")
	private String corpId;

	/**
	 * 线路方向列表，多个方向使用英文半角逗号分隔，支持在一次请求中分析同一条线路多种不同线路方向的客流
	 */
	@ApiField("directions")
	private String directions;

	/**
	 * 扩展参数，json格式，由双方约定取值
	 */
	@ApiField("ext_param")
	private String extParam;

	/**
	 * 线路Key，同一条线路的不同行驶方向，该值相同
	 */
	@ApiField("line_key")
	private String lineKey;

	/**
	 * 请求ID，唯一标识一次请求，由调用方自行确保唯一性
	 */
	@ApiField("request_id")
	private String requestId;

	/**
	 * 服务任务名称
	 */
	@ApiField("service_task_name")
	private String serviceTaskName;

	/**
	 * 聚合时间粒度，单位：分钟
	 */
	@ApiField("time_span")
	private Long timeSpan;

	public String getAlgoConfig() {
		return this.algoConfig;
	}
	public void setAlgoConfig(String algoConfig) {
		this.algoConfig = algoConfig;
	}

	public String getCityCode() {
		return this.cityCode;
	}
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}

	public String getCorpId() {
		return this.corpId;
	}
	public void setCorpId(String corpId) {
		this.corpId = corpId;
	}

	public String getDirections() {
		return this.directions;
	}
	public void setDirections(String directions) {
		this.directions = directions;
	}

	public String getExtParam() {
		return this.extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}

	public String getLineKey() {
		return this.lineKey;
	}
	public void setLineKey(String lineKey) {
		this.lineKey = lineKey;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getServiceTaskName() {
		return this.serviceTaskName;
	}
	public void setServiceTaskName(String serviceTaskName) {
		this.serviceTaskName = serviceTaskName;
	}

	public Long getTimeSpan() {
		return this.timeSpan;
	}
	public void setTimeSpan(Long timeSpan) {
		this.timeSpan = timeSpan;
	}

}
