package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 摊销计划创建
 *
 * @author auto create
 * @since 1.0, 2019-12-29 21:21:31
 */
public class AlipayBossFncDeferaccrualplanCreateModel extends AlipayObject {

	private static final long serialVersionUID = 6735286327849277119L;

	/**
	 * 合约号
	 */
	@ApiField("ar_no")
	private String arNo;

	/**
	 * 打包收费的类型
SERVICE_TIME 按照时间
SERVICE_QUANTITY 按照业务量
	 */
	@ApiField("biz_feepackage_type")
	private String bizFeepackageType;

	/**
	 * 业务请求号，与来源系统一起作为幂等
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 摊销方法类型，当前只支持直线摊销法
	 */
	@ApiField("calculate_type")
	private String calculateType;

	/**
	 * 收费项编码
	 */
	@ApiField("charge_item_code")
	private String chargeItemCode;

	/**
	 * 开始摊销的时间
	 */
	@ApiField("gmt_begin")
	private Date gmtBegin;

	/**
	 * 结束摊销的时间，且该时间大于开始摊销时间
	 */
	@ApiField("gmt_end")
	private Date gmtEnd;

	/**
	 * 该摊销业务发生的时间
	 */
	@ApiField("gmt_service")
	private Date gmtService;

	/**
	 * 确认收入所属ou
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 商户mid
	 */
	@ApiField("ip_id")
	private String ipId;

	/**
	 * 商户pid
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 收款方账号
银行or支付宝都可
	 */
	@ApiField("payee_account")
	private String payeeAccount;

	/**
	 * 付款方账号
银行 支付宝都可
	 */
	@ApiField("payer_account")
	private String payerAccount;

	/**
	 * 产品码
	 */
	@ApiField("prod_code")
	private String prodCode;

	/**
	 * 服务金额
总共需要摊销的金额
	 */
	@ApiField("service_amount")
	private MultiCurrencyMoneyOpenApi serviceAmount;

	/**
	 * 调用系统 
如 ACSELLCORE 销管平台
	 */
	@ApiField("source")
	private String source;

	/**
	 * 用户来源，如 usercenter 金融云
	 */
	@ApiField("user_source")
	private String userSource;

	public String getArNo() {
		return this.arNo;
	}
	public void setArNo(String arNo) {
		this.arNo = arNo;
	}

	public String getBizFeepackageType() {
		return this.bizFeepackageType;
	}
	public void setBizFeepackageType(String bizFeepackageType) {
		this.bizFeepackageType = bizFeepackageType;
	}

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getCalculateType() {
		return this.calculateType;
	}
	public void setCalculateType(String calculateType) {
		this.calculateType = calculateType;
	}

	public String getChargeItemCode() {
		return this.chargeItemCode;
	}
	public void setChargeItemCode(String chargeItemCode) {
		this.chargeItemCode = chargeItemCode;
	}

	public Date getGmtBegin() {
		return this.gmtBegin;
	}
	public void setGmtBegin(Date gmtBegin) {
		this.gmtBegin = gmtBegin;
	}

	public Date getGmtEnd() {
		return this.gmtEnd;
	}
	public void setGmtEnd(Date gmtEnd) {
		this.gmtEnd = gmtEnd;
	}

	public Date getGmtService() {
		return this.gmtService;
	}
	public void setGmtService(Date gmtService) {
		this.gmtService = gmtService;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getIpId() {
		return this.ipId;
	}
	public void setIpId(String ipId) {
		this.ipId = ipId;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getPayeeAccount() {
		return this.payeeAccount;
	}
	public void setPayeeAccount(String payeeAccount) {
		this.payeeAccount = payeeAccount;
	}

	public String getPayerAccount() {
		return this.payerAccount;
	}
	public void setPayerAccount(String payerAccount) {
		this.payerAccount = payerAccount;
	}

	public String getProdCode() {
		return this.prodCode;
	}
	public void setProdCode(String prodCode) {
		this.prodCode = prodCode;
	}

	public MultiCurrencyMoneyOpenApi getServiceAmount() {
		return this.serviceAmount;
	}
	public void setServiceAmount(MultiCurrencyMoneyOpenApi serviceAmount) {
		this.serviceAmount = serviceAmount;
	}

	public String getSource() {
		return this.source;
	}
	public void setSource(String source) {
		this.source = source;
	}

	public String getUserSource() {
		return this.userSource;
	}
	public void setUserSource(String userSource) {
		this.userSource = userSource;
	}

}
