package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 修改发票信息
 *
 * @author auto create
 * @since 1.0, 2019-12-17 14:49:08
 */
public class AlipayBossFncApinvoiceModifyModel extends AlipayObject {

	private static final long serialVersionUID = 2139882848528656857L;

	/**
	 * 应付对账单发票关联明细（ap_invoice_bill_link_orders与ap_invoice_order不能同时为空）
	 */
	@ApiListField("ap_invoice_bill_link_orders")
	@ApiField("ap_invoice_bill_link_order_request")
	private List<ApInvoiceBillLinkOrderRequest> apInvoiceBillLinkOrders;

	/**
	 * 应付发票（ap_invoice_bill_link_orders与ap_invoice_order不能同时为空）
	 */
	@ApiField("ap_invoice_order")
	private ApInvoiceOrderRequest apInvoiceOrder;

	/**
	 * 发票ID(修改发票时必填)
	 */
	@ApiField("invoice_id")
	private String invoiceId;

	/**
	 * 发票备注信息,需小于300字
	 */
	@ApiField("memo")
	private String memo;

	/**
	 * 是否自动进行税损调账(默认 false)
	 */
	@ApiField("need_auto_tax_loss_adjust")
	private Boolean needAutoTaxLossAdjust;

	/**
	 * 当前操作人
	 */
	@ApiField("operator")
	private String operator;

	/**
	 * 当前操作人类型(修改发票时必填),01:ISV 02:管理员(小二)  默认01
	 */
	@ApiField("operator_type")
	private String operatorType;

	/**
	 * 个人无票税损比例
	 */
	@ApiField("personal_tax_loss_rate")
	private Long personalTaxLossRate;

	public List<ApInvoiceBillLinkOrderRequest> getApInvoiceBillLinkOrders() {
		return this.apInvoiceBillLinkOrders;
	}
	public void setApInvoiceBillLinkOrders(List<ApInvoiceBillLinkOrderRequest> apInvoiceBillLinkOrders) {
		this.apInvoiceBillLinkOrders = apInvoiceBillLinkOrders;
	}

	public ApInvoiceOrderRequest getApInvoiceOrder() {
		return this.apInvoiceOrder;
	}
	public void setApInvoiceOrder(ApInvoiceOrderRequest apInvoiceOrder) {
		this.apInvoiceOrder = apInvoiceOrder;
	}

	public String getInvoiceId() {
		return this.invoiceId;
	}
	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getMemo() {
		return this.memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Boolean getNeedAutoTaxLossAdjust() {
		return this.needAutoTaxLossAdjust;
	}
	public void setNeedAutoTaxLossAdjust(Boolean needAutoTaxLossAdjust) {
		this.needAutoTaxLossAdjust = needAutoTaxLossAdjust;
	}

	public String getOperator() {
		return this.operator;
	}
	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getOperatorType() {
		return this.operatorType;
	}
	public void setOperatorType(String operatorType) {
		this.operatorType = operatorType;
	}

	public Long getPersonalTaxLossRate() {
		return this.personalTaxLossRate;
	}
	public void setPersonalTaxLossRate(Long personalTaxLossRate) {
		this.personalTaxLossRate = personalTaxLossRate;
	}

}
