package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 查询车辆的车况信息
 *
 * @author auto create
 * @since 1.0, 2020-04-09 15:22:51
 */
public class AliosOpenAutoStatusQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3547961872722142299L;

	/**
	 * 车机设备的设备标识，通过my.aliauto.getDeviceInfo JSAPI获取。
	 */
	@ApiField("device_token")
	private String deviceToken;

	/**
	 * 每次请求的唯一标识
	 */
	@ApiField("trace_id")
	private String traceId;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getDeviceToken() {
		return this.deviceToken;
	}
	public void setDeviceToken(String deviceToken) {
		this.deviceToken = deviceToken;
	}

	public String getTraceId() {
		return this.traceId;
	}
	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
