package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 绝对时间配置
 *
 * @author auto create
 * @since 1.0, 2020-03-19 11:14:02
 */
public class AbsolutePeriod extends AlipayObject {

	private static final long serialVersionUID = 1822172564299894521L;

	/**
	 * 奖品激活时间，奖品为代金券有效
	 */
	@ApiField("active_time")
	private Date activeTime;

	/**
	 * 奖品过期时间，奖品为代金券有效
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 奖品展期时间，用于控制奖品使用后发生退回用户，还可再延长多少使用时间，奖品为代金券有效
	 */
	@ApiField("extend_time")
	private Date extendTime;

	public Date getActiveTime() {
		return this.activeTime;
	}
	public void setActiveTime(Date activeTime) {
		this.activeTime = activeTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getExtendTime() {
		return this.extendTime;
	}
	public void setExtendTime(Date extendTime) {
		this.extendTime = extendTime;
	}

}
