/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import com.google.gson.Gson;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.zhipu.AuthorizationInterceptor;
import dev.langchain4j.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.model.zhipu.Json;
import dev.langchain4j.model.zhipu.RequestLoggingInterceptor;
import dev.langchain4j.model.zhipu.ResponseLoggingInterceptor;
import dev.langchain4j.model.zhipu.ZhipuAiApi;
import dev.langchain4j.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.model.zhipu.chat.ToolCall;
import dev.langchain4j.model.zhipu.embedding.EmbeddingRequest;
import dev.langchain4j.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.model.zhipu.shared.Usage;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ZhipuAiClient {
    private static final Logger log = LoggerFactory.getLogger(ZhipuAiClient.class);
    private final String baseUrl;
    private final ZhipuAiApi zhipuAiApi;
    private final OkHttpClient okHttpClient;
    private final Boolean logResponses;

    public ZhipuAiClient(Builder builder) {
        this.baseUrl = builder.baseUrl;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.callTimeout).connectTimeout(builder.connectTimeout).readTimeout(builder.readTimeout).writeTimeout(builder.writeTimeout).addInterceptor((Interceptor)new AuthorizationInterceptor(builder.apiKey));
        if (builder.logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        this.logResponses = builder.logResponses;
        if (builder.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(ZhipuAiClient.formattedUrlForRetrofit(this.baseUrl)).client(this.okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)Json.GSON)).build();
        this.zhipuAiApi = (ZhipuAiApi)retrofit.create(ZhipuAiApi.class);
    }

    private static String formattedUrlForRetrofit(String baseUrl) {
        return baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatCompletionResponse chatCompletion(ChatCompletionRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.zhipuAiApi.chatCompletion(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (ChatCompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public EmbeddingResponse embedAll(EmbeddingRequest request) {
        try {
            retrofit2.Response responseResponse = this.zhipuAiApi.embeddings(request).execute();
            if (responseResponse.isSuccessful()) {
                return (EmbeddingResponse)responseResponse.body();
            }
            throw this.toException(responseResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void streamingChatCompletion(ChatCompletionRequest request, final StreamingResponseHandler<AiMessage> handler) {
        EventSourceListener eventSourceListener = new EventSourceListener(){
            final StringBuffer contentBuilder = new StringBuffer();
            List<ToolExecutionRequest> specifications;
            TokenUsage tokenUsage;
            FinishReason finishReason;

            public void onOpen(EventSource eventSource, okhttp3.Response response) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onOpen()");
                }
            }

            public void onEvent(EventSource eventSource, String id, String type, String data) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onEvent() {}", (Object)data);
                }
                if ("[DONE]".equals(data)) {
                    AiMessage aiMessage = Utils.isNullOrEmpty(this.specifications) ? AiMessage.from((String)this.contentBuilder.toString()) : AiMessage.from(this.specifications);
                    Response response = Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
                    handler.onComplete(response);
                } else {
                    try {
                        List<ToolCall> toolCalls;
                        String finishReasonString;
                        ChatCompletionResponse chatCompletionResponse = Json.fromJson(data, ChatCompletionResponse.class);
                        ChatCompletionChoice zhipuChatCompletionChoice = chatCompletionResponse.getChoices().get(0);
                        String chunk = zhipuChatCompletionChoice.getDelta().getContent();
                        this.contentBuilder.append(chunk);
                        handler.onNext(chunk);
                        Usage zhipuUsageInfo = chatCompletionResponse.getUsage();
                        if (zhipuUsageInfo != null) {
                            this.tokenUsage = DefaultZhipuAiHelper.tokenUsageFrom(zhipuUsageInfo);
                        }
                        if ((finishReasonString = zhipuChatCompletionChoice.getFinishReason()) != null) {
                            this.finishReason = DefaultZhipuAiHelper.finishReasonFrom(finishReasonString);
                        }
                        if (!Utils.isNullOrEmpty(toolCalls = zhipuChatCompletionChoice.getDelta().getToolCalls())) {
                            this.specifications = DefaultZhipuAiHelper.specificationsFrom(toolCalls);
                        }
                    }
                    catch (Exception e) {
                        handler.onError((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onFailure(EventSource eventSource, Throwable t, okhttp3.Response response) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onFailure()", t);
                }
                if (t != null) {
                    handler.onError(t);
                } else {
                    handler.onError((Throwable)new RuntimeException(String.format("status code: %s; body: %s", response.code(), response.body())));
                }
            }

            public void onClosed(EventSource eventSource) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onClosed()");
                }
            }
        };
        EventSources.createFactory((OkHttpClient)this.okHttpClient).newEventSource(this.zhipuAiApi.streamingChatCompletion(request).request(), eventSourceListener);
    }

    private RuntimeException toException(retrofit2.Response<?> retrofitResponse) throws IOException {
        ResponseBody errorBody;
        int code = retrofitResponse.code();
        if (code >= 400 && (errorBody = retrofitResponse.errorBody()) != null) {
            String errorBodyString = errorBody.string();
            String errorMessage = String.format("status code: %s; body: %s", code, errorBodyString);
            log.error("Error response: {}", (Object)errorMessage);
            return new RuntimeException(errorMessage);
        }
        return new RuntimeException(retrofitResponse.message());
    }

    public static class Builder {
        private String baseUrl = "https://open.bigmodel.cn/";
        private String apiKey;
        private Duration callTimeout = Duration.ofSeconds(60L);
        private Duration connectTimeout = Duration.ofSeconds(60L);
        private Duration readTimeout = Duration.ofSeconds(60L);
        private Duration writeTimeout = Duration.ofSeconds(60L);
        private boolean logRequests;
        private boolean logResponses;

        private Builder() {
        }

        public Builder baseUrl(String baseUrl) {
            if (baseUrl != null && !baseUrl.trim().isEmpty()) {
                this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
                return this;
            }
            throw new IllegalArgumentException("baseUrl cannot be null or empty");
        }

        public Builder apiKey(String apiKey) {
            if (apiKey != null && !apiKey.trim().isEmpty()) {
                this.apiKey = apiKey;
                return this;
            }
            throw new IllegalArgumentException("apiKey cannot be null or empty. ");
        }

        public Builder callTimeout(Duration callTimeout) {
            if (callTimeout == null) {
                throw new IllegalArgumentException("callTimeout cannot be null");
            }
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            if (connectTimeout == null) {
                throw new IllegalArgumentException("connectTimeout cannot be null");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            if (readTimeout == null) {
                throw new IllegalArgumentException("readTimeout cannot be null");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            if (writeTimeout == null) {
                throw new IllegalArgumentException("writeTimeout cannot be null");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder logRequests() {
            return this.logRequests(true);
        }

        public Builder logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses() {
            return this.logResponses(true);
        }

        public Builder logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiClient build() {
            return new ZhipuAiClient(this);
        }
    }
}

