/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
class EmbeddingRequest {
    private String model;
    private List<String> input;

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<String> getInput() {
        return this.input;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setInput(List<String> input) {
        this.input = input;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingRequest)) {
            return false;
        }
        EmbeddingRequest other = (EmbeddingRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<String> this$input = this.getInput();
        List<String> other$input = other.getInput();
        return !(this$input == null ? other$input != null : !((Object)this$input).equals(other$input));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<String> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingRequest(model=" + this.getModel() + ", input=" + this.getInput() + ")";
    }

    public EmbeddingRequest() {
    }

    public EmbeddingRequest(String model, List<String> input) {
        this.model = model;
        this.input = input;
    }

    public static class EmbeddingRequestBuilder {
        private String model;
        private List<String> input;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder input(List<String> input) {
            this.input = input;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.input);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model=" + this.model + ", input=" + this.input + ")";
        }
    }
}

