/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.ContainsString;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

class MilvusMetadataFilterMapper {
    MilvusMetadataFilterMapper() {
    }

    static String map(Filter filter, String metadataFieldName) {
        if (filter instanceof ContainsString) {
            ContainsString containsString = (ContainsString)filter;
            return MilvusMetadataFilterMapper.mapContains(containsString, metadataFieldName);
        }
        if (filter instanceof IsEqualTo) {
            IsEqualTo isEqualTo = (IsEqualTo)filter;
            return MilvusMetadataFilterMapper.mapEqual(isEqualTo, metadataFieldName);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo isNotEqualTo = (IsNotEqualTo)filter;
            return MilvusMetadataFilterMapper.mapNotEqual(isNotEqualTo, metadataFieldName);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan isGreaterThan = (IsGreaterThan)filter;
            return MilvusMetadataFilterMapper.mapGreaterThan(isGreaterThan, metadataFieldName);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo isGreaterThanOrEqualTo = (IsGreaterThanOrEqualTo)filter;
            return MilvusMetadataFilterMapper.mapGreaterThanOrEqual(isGreaterThanOrEqualTo, metadataFieldName);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan isLessThan = (IsLessThan)filter;
            return MilvusMetadataFilterMapper.mapLessThan(isLessThan, metadataFieldName);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo isLessThanOrEqualTo = (IsLessThanOrEqualTo)filter;
            return MilvusMetadataFilterMapper.mapLessThanOrEqual(isLessThanOrEqualTo, metadataFieldName);
        }
        if (filter instanceof IsIn) {
            IsIn isIn = (IsIn)filter;
            return MilvusMetadataFilterMapper.mapIn(isIn, metadataFieldName);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn isNotIn = (IsNotIn)filter;
            return MilvusMetadataFilterMapper.mapNotIn(isNotIn, metadataFieldName);
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return MilvusMetadataFilterMapper.mapAnd(and, metadataFieldName);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return MilvusMetadataFilterMapper.mapNot(not, metadataFieldName);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return MilvusMetadataFilterMapper.mapOr(or, metadataFieldName);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private static String mapContains(ContainsString containsString, String metadataFieldName) {
        return String.format("%s LIKE %s", MilvusMetadataFilterMapper.formatKey(containsString.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue("%" + containsString.comparisonValue() + "%"));
    }

    private static String mapEqual(IsEqualTo isEqualTo, String metadataFieldName) {
        return String.format("%s == %s", MilvusMetadataFilterMapper.formatKey(isEqualTo.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isEqualTo.comparisonValue()));
    }

    private static String mapNotEqual(IsNotEqualTo isNotEqualTo, String metadataFieldName) {
        return String.format("%s != %s", MilvusMetadataFilterMapper.formatKey(isNotEqualTo.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isNotEqualTo.comparisonValue()));
    }

    private static String mapGreaterThan(IsGreaterThan isGreaterThan, String metadataFieldName) {
        return String.format("%s > %s", MilvusMetadataFilterMapper.formatKey(isGreaterThan.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isGreaterThan.comparisonValue()));
    }

    private static String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo, String metadataFieldName) {
        return String.format("%s >= %s", MilvusMetadataFilterMapper.formatKey(isGreaterThanOrEqualTo.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isGreaterThanOrEqualTo.comparisonValue()));
    }

    private static String mapLessThan(IsLessThan isLessThan, String metadataFieldName) {
        return String.format("%s < %s", MilvusMetadataFilterMapper.formatKey(isLessThan.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isLessThan.comparisonValue()));
    }

    private static String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo, String metadataFieldName) {
        return String.format("%s <= %s", MilvusMetadataFilterMapper.formatKey(isLessThanOrEqualTo.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValue(isLessThanOrEqualTo.comparisonValue()));
    }

    private static String mapIn(IsIn isIn, String metadataFieldName) {
        return String.format("%s in %s", MilvusMetadataFilterMapper.formatKey(isIn.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValues(isIn.comparisonValues()));
    }

    private static String mapNotIn(IsNotIn isNotIn, String metadataFieldName) {
        return String.format("%s not in %s", MilvusMetadataFilterMapper.formatKey(isNotIn.key(), metadataFieldName), MilvusMetadataFilterMapper.formatValues(isNotIn.comparisonValues()));
    }

    private static String mapAnd(And and, String metadataFieldName) {
        return String.format("%s and %s", MilvusMetadataFilterMapper.map(and.left(), metadataFieldName), MilvusMetadataFilterMapper.map(and.right(), metadataFieldName));
    }

    private static String mapNot(Not not, String metadataFieldName) {
        return String.format("not(%s)", MilvusMetadataFilterMapper.map(not.expression(), metadataFieldName));
    }

    private static String mapOr(Or or, String metadataFieldName) {
        return String.format("(%s or %s)", MilvusMetadataFilterMapper.map(or.left(), metadataFieldName), MilvusMetadataFilterMapper.map(or.right(), metadataFieldName));
    }

    private static String formatKey(String key, String metadataFieldName) {
        return metadataFieldName + "[\"" + key + "\"]";
    }

    private static String formatValue(Object value) {
        if (value instanceof String || value instanceof UUID) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return value.toString();
    }

    protected static List<String> formatValues(Collection<?> values) {
        return values.stream().map(MilvusMetadataFilterMapper::formatValue).collect(Collectors.toList());
    }
}

