/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import dev.langchain4j.model.huggingface.DefaultHuggingFaceClient;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.spi.HuggingFaceClientFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Collection;
import java.util.Iterator;

class FactoryCreator {
    static final HuggingFaceClientFactory FACTORY = FactoryCreator.factory();

    FactoryCreator() {
    }

    private static HuggingFaceClientFactory factory() {
        Collection factories = ServiceHelper.loadFactories(HuggingFaceClientFactory.class);
        Iterator iterator = factories.iterator();
        if (iterator.hasNext()) {
            HuggingFaceClientFactory factory = (HuggingFaceClientFactory)iterator.next();
            return factory;
        }
        return new DefaultHuggingFaceClientFactory();
    }

    static class DefaultHuggingFaceClientFactory
    implements HuggingFaceClientFactory {
        DefaultHuggingFaceClientFactory() {
        }

        @Override
        public HuggingFaceClient create(HuggingFaceClientFactory.Input input) {
            return new DefaultHuggingFaceClient(input.apiKey(), input.modelId(), input.timeout());
        }
    }
}

