/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesis;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisParam;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisResult;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.dashscope.WanxHelper;
import dev.langchain4j.model.dashscope.WanxImageRefMode;
import dev.langchain4j.model.dashscope.WanxImageSize;
import dev.langchain4j.model.dashscope.WanxImageStyle;
import dev.langchain4j.model.dashscope.spi.WanxImageModelBuilderFactory;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;

public class WanxImageModel
implements ImageModel {
    private final String apiKey;
    private final String modelName;
    private final WanxImageRefMode refMode;
    private final Float refStrength;
    private final Integer seed;
    private final WanxImageSize size;
    private final WanxImageStyle style;
    private final ImageSynthesis imageSynthesis;

    public WanxImageModel(String baseUrl, String apiKey, String modelName, WanxImageRefMode refMode, Float refStrength, Integer seed, WanxImageSize size, WanxImageStyle style) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "wanx-v1" : modelName;
        this.apiKey = apiKey;
        this.refMode = refMode;
        this.refStrength = refStrength;
        this.seed = seed;
        this.size = size;
        this.style = style;
        this.imageSynthesis = Utils.isNullOrBlank((String)baseUrl) ? new ImageSynthesis() : new ImageSynthesis("text2image", baseUrl);
    }

    public Response<Image> generate(String prompt) {
        ImageSynthesisParam param = this.requestBuilder(prompt).n(Integer.valueOf(1)).build();
        try {
            ImageSynthesisResult result = this.imageSynthesis.call(param);
            return Response.from((Object)WanxHelper.imagesFrom(result).get(0));
        }
        catch (NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<List<Image>> generate(String prompt, int n) {
        ImageSynthesisParam param = this.requestBuilder(prompt).n(Integer.valueOf(n)).build();
        try {
            ImageSynthesisResult result = this.imageSynthesis.call(param);
            return Response.from(WanxHelper.imagesFrom(result));
        }
        catch (NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Image> edit(Image image, String prompt) {
        String imageUrl = WanxHelper.imageUrl(image, this.modelName, this.apiKey);
        ImageSynthesisParam.ImageSynthesisParamBuilder builder = this.requestBuilder(prompt).refImage(imageUrl).n(Integer.valueOf(1));
        if (imageUrl.startsWith("oss://")) {
            builder.header("X-DashScope-OssResourceResolve", (Object)"enable");
        }
        try {
            ImageSynthesisResult result = this.imageSynthesis.call(builder.build());
            return Response.from((Object)WanxHelper.imagesFrom(result).get(0));
        }
        catch (NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    private ImageSynthesisParam.ImageSynthesisParamBuilder<?, ?> requestBuilder(String prompt) {
        ImageSynthesisParam.ImageSynthesisParamBuilder builder = ((ImageSynthesisParam.ImageSynthesisParamBuilder)((ImageSynthesisParam.ImageSynthesisParamBuilder)ImageSynthesisParam.builder().apiKey(this.apiKey)).model(this.modelName)).prompt(prompt);
        if (this.seed != null) {
            builder.seed(this.seed);
        }
        if (this.size != null) {
            builder.size(this.size.toString());
        }
        if (this.style != null) {
            builder.style(this.style.toString());
        }
        if (this.refMode != null) {
            builder.parameter("ref_mode", (Object)this.refMode.toString());
        }
        if (this.refStrength != null) {
            builder.parameter("ref_strength", (Object)this.refStrength);
        }
        return builder;
    }

    public static WanxImageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(WanxImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            WanxImageModelBuilderFactory factory = (WanxImageModelBuilderFactory)iterator.next();
            return (WanxImageModelBuilder)factory.get();
        }
        return new WanxImageModelBuilder();
    }

    public static class WanxImageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private WanxImageRefMode refMode;
        private Float refStrength;
        private Integer seed;
        private WanxImageSize size;
        private WanxImageStyle style;

        public WanxImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public WanxImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public WanxImageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public WanxImageModelBuilder refMode(WanxImageRefMode refMode) {
            this.refMode = refMode;
            return this;
        }

        public WanxImageModelBuilder refStrength(Float refStrength) {
            this.refStrength = refStrength;
            return this;
        }

        public WanxImageModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public WanxImageModelBuilder size(WanxImageSize size) {
            this.size = size;
            return this;
        }

        public WanxImageModelBuilder style(WanxImageStyle style) {
            this.style = style;
            return this;
        }

        public WanxImageModel build() {
            return new WanxImageModel(this.baseUrl, this.apiKey, this.modelName, this.refMode, this.refStrength, this.seed, this.size, this.style);
        }

        public String toString() {
            return "WanxImageModel.WanxImageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", refMode=" + (Object)((Object)this.refMode) + ", refStrength=" + this.refStrength + ", seed=" + this.seed + ", size=" + (Object)((Object)this.size) + ", style=" + (Object)((Object)this.style) + ")";
        }
    }
}

