/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.dashscope.spi.QwenChatModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;

public class QwenChatModel
implements ChatLanguageModel {
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final boolean isMultimodalModel;

    protected QwenChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.isMultimodalModel = QwenHelper.isMultimodalModel(modelName);
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation() : null;
            this.generation = this.isMultimodalModel ? null : new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.isMultimodalModel ? this.generateByMultimodalModel(messages) : this.generateByNonMultimodalModel(messages);
    }

    private Response<AiMessage> generateByNonMultimodalModel(List<ChatMessage> messages) {
        try {
            QwenParam.QwenParamBuilder builder = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).repetitionPenalty(this.repetitionPenalty).temperature(this.temperature).maxTokens(this.maxTokens).messages(QwenHelper.toQwenMessages(messages)).resultFormat(QwenParam.ResultFormat.MESSAGE);
            if (this.stops != null) {
                builder.stopStrings(this.stops);
            }
            GenerationResult generationResult = this.generation.call((HalfDuplexServiceParam)builder.build());
            String answer = QwenHelper.answerFrom(generationResult);
            return Response.from((Object)AiMessage.from((String)answer), (TokenUsage)QwenHelper.tokenUsageFrom(generationResult), (FinishReason)QwenHelper.finishReasonFrom(generationResult));
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    private Response<AiMessage> generateByMultimodalModel(List<ChatMessage> messages) {
        try {
            MultiModalConversationParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).temperature(this.temperature).maxLength(this.maxTokens).messages(QwenHelper.toQwenMultiModalMessages(messages)).build();
            MultiModalConversationResult result = this.conv.call(param);
            String answer = QwenHelper.answerFrom(result);
            return Response.from((Object)AiMessage.from((String)answer), (TokenUsage)QwenHelper.tokenUsageFrom(result), (FinishReason)QwenHelper.finishReasonFrom(result));
        }
        catch (NoApiKeyException | UploadFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static QwenChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenChatModelBuilderFactory factory = (QwenChatModelBuilderFactory)iterator.next();
            return (QwenChatModelBuilder)factory.get();
        }
        return new QwenChatModelBuilder();
    }

    public static class QwenChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;

        public QwenChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenChatModel build() {
            return new QwenChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens);
        }

        public String toString() {
            return "QwenChatModel.QwenChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch=" + this.enableSearch + ", seed=" + this.seed + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stops=" + this.stops + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

