/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.rag.content.ContentMetadata;
import java.util.Map;
import java.util.Objects;

public class Content {
    private final TextSegment textSegment;
    private final Map<ContentMetadata, Object> metadata;

    public Content(String text) {
        this(TextSegment.from(text), Map.of());
    }

    public Content(TextSegment textSegment) {
        this(textSegment, Map.of());
    }

    public Content(TextSegment textSegment, Map<ContentMetadata, Object> metadata) {
        this.textSegment = ValidationUtils.ensureNotNull(textSegment, "textSegment");
        this.metadata = metadata == null ? Map.of() : Map.copyOf(metadata);
    }

    public TextSegment textSegment() {
        return this.textSegment;
    }

    public Map<ContentMetadata, Object> metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content that = (Content)o;
        return Objects.equals(this.textSegment, that.textSegment);
    }

    public int hashCode() {
        return Objects.hash(this.textSegment);
    }

    public String toString() {
        return "Content { textSegment = " + String.valueOf(this.textSegment) + ", metadata = " + String.valueOf(this.metadata) + " }";
    }

    public static Content from(String text) {
        return new Content(text);
    }

    public static Content from(TextSegment textSegment) {
        return new Content(textSegment);
    }

    public static Content from(TextSegment textSegment, Map<ContentMetadata, Object> metadata) {
        return new Content(textSegment, metadata);
    }
}

