/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.internal.Utils;
import java.util.Objects;

public class JsonSchemaProperty {
    public static final JsonSchemaProperty STRING = JsonSchemaProperty.type("string");
    public static final JsonSchemaProperty INTEGER = JsonSchemaProperty.type("integer");
    public static final JsonSchemaProperty NUMBER = JsonSchemaProperty.type("number");
    public static final JsonSchemaProperty OBJECT = JsonSchemaProperty.type("object");
    public static final JsonSchemaProperty ARRAY = JsonSchemaProperty.type("array");
    public static final JsonSchemaProperty BOOLEAN = JsonSchemaProperty.type("boolean");
    public static final JsonSchemaProperty NULL = JsonSchemaProperty.type("null");
    private final String key;
    private final Object value;

    public JsonSchemaProperty(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonSchemaProperty && this.equalTo((JsonSchemaProperty)another);
    }

    private boolean equalTo(JsonSchemaProperty another) {
        return Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "JsonSchemaProperty { key = " + Utils.quoted(this.key) + ", value = " + this.value + " }";
    }

    public static JsonSchemaProperty from(String key, Object value) {
        return new JsonSchemaProperty(key, value);
    }

    public static JsonSchemaProperty property(String key, Object value) {
        return JsonSchemaProperty.from(key, value);
    }

    public static JsonSchemaProperty type(String value) {
        return JsonSchemaProperty.from("type", value);
    }

    public static JsonSchemaProperty description(String value) {
        return JsonSchemaProperty.from("description", value);
    }

    public static JsonSchemaProperty enums(String ... enumValues) {
        return JsonSchemaProperty.from("enum", enumValues);
    }

    public static JsonSchemaProperty enums(Object ... enumValues) {
        for (Object enumValue : enumValues) {
            if (enumValue.getClass().isEnum()) continue;
            throw new RuntimeException("Value " + enumValue.getClass().getName() + " should be enum");
        }
        return JsonSchemaProperty.from("enum", enumValues);
    }

    public static JsonSchemaProperty enums(Class<?> enumClass) {
        if (!enumClass.isEnum()) {
            throw new RuntimeException("Class " + enumClass.getName() + " should be enum");
        }
        return JsonSchemaProperty.from("enum", enumClass.getEnumConstants());
    }
}

