/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.community.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.community.model.zhipu.ZhipuAiClient;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.community.model.zhipu.spi.ZhipuAiStreamingChatModelBuilderFactory;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhipuAiStreamingChatModel
implements StreamingChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(ZhipuAiStreamingChatModel.class);
    private final Double temperature;
    private final Double topP;
    private final String model;
    private final List<String> stops;
    private final Integer maxToken;
    private final ZhipuAiClient client;
    private final List<ChatModelListener> listeners;

    public ZhipuAiStreamingChatModel(String baseUrl, String apiKey, Double temperature, Double topP, List<String> stops, String model, Integer maxToken, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.stops = stops;
        this.model = (String)Utils.getOrDefault((Object)model, (Object)ChatCompletionModel.GLM_4_FLASH.toString());
        this.maxToken = (Integer)Utils.getOrDefault((Object)maxToken, (Object)512);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.client = ZhipuAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/")).apiKey(apiKey).callTimeout(callTimeout).connectTimeout(connectTimeout).writeTimeout(writeTimeout).readTimeout(readTimeout).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public void doChat(ChatRequest request, StreamingChatResponseHandler handler) {
        List messages = request.messages();
        List toolSpecifications = request.toolSpecifications();
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(this.model).maxTokens(this.maxToken).stream(true).stop(this.stops).topP(this.topP).temperature(this.temperature).toolChoice(ToolChoiceMode.AUTO).messages(DefaultZhipuAiHelper.toZhipuAiMessages(messages));
        if (!Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            requestBuilder.tools(DefaultZhipuAiHelper.toTools(toolSpecifications));
        }
        ChatCompletionRequest completionRequest = requestBuilder.build();
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(request, this.provider(), attributes);
        for (ChatModelListener chatModelListener : this.listeners) {
            try {
                chatModelListener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        }
        this.client.streamingChatCompletion(completionRequest, handler, this.listeners, requestContext, this.provider());
    }

    public static ZhipuAiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiStreamingChatModelBuilderFactory factories = (ZhipuAiStreamingChatModelBuilderFactory)iterator.next();
            return (ZhipuAiStreamingChatModelBuilder)factories.get();
        }
        return new ZhipuAiStreamingChatModelBuilder();
    }

    public static class ZhipuAiStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private List<String> stops;
        private String model;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Duration callTimeout;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        public ZhipuAiStreamingChatModelBuilder model(ChatCompletionModel model) {
            this.model = model.toString();
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder model(String model) {
            ValidationUtils.ensureNotBlank((String)model, (String)"model");
            this.model = model;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModel build() {
            return new ZhipuAiStreamingChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.stops, this.model, this.maxToken, this.logRequests, this.logResponses, this.listeners, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }
    }
}

