/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.community.model.zhipu.ZhipuAiClient;
import dev.langchain4j.community.model.zhipu.image.ImageModelName;
import dev.langchain4j.community.model.zhipu.image.ImageRequest;
import dev.langchain4j.community.model.zhipu.image.ImageResponse;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import java.time.Duration;

public class ZhipuAiImageModel
implements ImageModel {
    private final String model;
    private final String userId;
    private final Integer maxRetries;
    private final ZhipuAiClient client;

    public ZhipuAiImageModel(String model, String userId, String apiKey, String baseUrl, Integer maxRetries, Boolean logRequests, Boolean logResponses, Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.model = (String)Utils.getOrDefault((Object)model, (Object)ImageModelName.COGVIEW_3.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.userId = userId;
        this.client = ZhipuAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/")).apiKey(apiKey).callTimeout(callTimeout).connectTimeout(connectTimeout).writeTimeout(writeTimeout).readTimeout(readTimeout).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public static ZhipuAiImageModelBuilder builder() {
        return new ZhipuAiImageModelBuilder();
    }

    public Response<Image> generate(String prompt) {
        ImageRequest request = ImageRequest.builder().prompt(prompt).userId(this.userId).model(this.model).build();
        ImageResponse response = (ImageResponse)RetryUtils.withRetry(() -> this.client.imagesGeneration(request), (int)this.maxRetries);
        if (response == null) {
            return Response.from((Object)Image.builder().build());
        }
        return Response.from((Object)Image.builder().url(response.getData().get(0).getUrl()).build());
    }

    public static class ZhipuAiImageModelBuilder {
        private String model;
        private String userId;
        private String apiKey;
        private String baseUrl;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private Duration callTimeout;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        ZhipuAiImageModelBuilder() {
        }

        public ZhipuAiImageModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiImageModelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ZhipuAiImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiImageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZhipuAiImageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiImageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiImageModelBuilder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public ZhipuAiImageModelBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ZhipuAiImageModelBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ZhipuAiImageModelBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ZhipuAiImageModel build() {
            return new ZhipuAiImageModel(this.model, this.userId, this.apiKey, this.baseUrl, this.maxRetries, this.logRequests, this.logResponses, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }
    }
}

