/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.community.model.zhipu.Json;
import dev.langchain4j.community.model.zhipu.shared.ErrorResponse;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ZhipuAiException
extends RuntimeException {
    private String code;
    private String message;

    public ZhipuAiException(String code, String message) {
        super(message);
        this.code = code;
    }

    public ZhipuAiException(Response response) {
        try {
            ResponseBody body = response.body();
            if (body != null) {
                ErrorResponse errorResponse = Json.fromJson(body.string(), ErrorResponse.class);
                this.message = errorResponse.getError().get("message");
                this.code = errorResponse.getError().get("code");
            }
        }
        catch (IOException ignored) {
            this.message = "null";
            this.code = String.valueOf(response.code());
        }
    }

    public ZhipuAiException(String message) {
        super(message);
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

