/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.community.model.zhipu.ZhipuAiClient;
import dev.langchain4j.community.model.zhipu.ZhipuAiException;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.community.model.zhipu.spi.ZhipuAiChatModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhipuAiChatModel
implements ChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(ZhipuAiChatModel.class);
    private final Double temperature;
    private final Double topP;
    private final String model;
    private final Integer maxRetries;
    private final Integer maxToken;
    private final List<String> stops;
    private final ZhipuAiClient client;
    private final List<ChatModelListener> listeners;

    public ZhipuAiChatModel(String baseUrl, String apiKey, Double temperature, Double topP, String model, List<String> stops, Integer maxRetries, Integer maxToken, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.stops = stops;
        this.model = (String)Utils.getOrDefault((Object)model, (Object)ChatCompletionModel.GLM_4_FLASH.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.maxToken = (Integer)Utils.getOrDefault((Object)maxToken, (Object)512);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.client = ZhipuAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/")).apiKey(apiKey).callTimeout(callTimeout).connectTimeout(connectTimeout).writeTimeout(writeTimeout).readTimeout(readTimeout).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public static ZhipuAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiChatModelBuilderFactory factories = (ZhipuAiChatModelBuilderFactory)iterator.next();
            return (ZhipuAiChatModelBuilder)factories.get();
        }
        return new ZhipuAiChatModelBuilder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, (ToolSpecification)null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(this.model).maxTokens(this.maxToken).stream(false).topP(this.topP).stop(this.stops).temperature(this.temperature).toolChoice(ToolChoiceMode.AUTO).messages(DefaultZhipuAiHelper.toZhipuAiMessages(messages));
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(DefaultZhipuAiHelper.toTools(toolSpecifications));
        }
        ChatCompletionRequest request = requestBuilder.build();
        ChatModelRequest modelListenerRequest = DefaultZhipuAiHelper.createModelListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        for (ChatModelListener chatModelListener : this.listeners) {
            try {
                chatModelListener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        }
        ChatCompletionResponse response = (ChatCompletionResponse)RetryUtils.withRetry(() -> this.client.chatCompletion(request), (int)this.maxRetries);
        FinishReason finishReason = DefaultZhipuAiHelper.finishReasonFrom(response.getChoices().get(0).getFinishReason());
        Response messageResponse = Response.from((Object)DefaultZhipuAiHelper.aiMessageFrom(response), (TokenUsage)DefaultZhipuAiHelper.tokenUsageFrom(response.getUsage()), (FinishReason)finishReason);
        this.listeners.forEach(listener -> {
            try {
                if (DefaultZhipuAiHelper.isSuccessFinishReason(finishReason)) {
                    listener.onResponse(new ChatModelResponseContext(DefaultZhipuAiHelper.createModelListenerResponse(response.getId(), request.getModel(), (Response<AiMessage>)messageResponse), modelListenerRequest, attributes));
                } else {
                    listener.onError(new ChatModelErrorContext((Throwable)new ZhipuAiException(((AiMessage)messageResponse.content()).text()), modelListenerRequest, null, attributes));
                }
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        return messageResponse;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, toolSpecification != null ? Collections.singletonList(toolSpecification) : null);
    }

    public static class ZhipuAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private String model;
        private List<String> stops;
        private Integer maxRetries;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Duration callTimeout;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        public ZhipuAiChatModelBuilder model(ChatCompletionModel model) {
            this.model = model.toString();
            return this;
        }

        public ZhipuAiChatModelBuilder model(String model) {
            ValidationUtils.ensureNotBlank((String)model, (String)"model");
            this.model = model;
            return this;
        }

        public ZhipuAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public ZhipuAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZhipuAiChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public ZhipuAiChatModelBuilder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public ZhipuAiChatModelBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ZhipuAiChatModelBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ZhipuAiChatModelBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ZhipuAiChatModel build() {
            return new ZhipuAiChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.model, this.stops, this.maxRetries, this.maxToken, this.logRequests, this.logResponses, this.listeners, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }
    }
}

