/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.redis;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.search.schemafields.NumericField;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TagField;
import redis.clients.jedis.search.schemafields.TextField;

class RedisMetadataFilterMapper {
    private static final String FILTER_PREFIX = "@";
    private static final String NOT_PREFIX = "-";
    private static final String OR_DELIMITER = " | ";
    private final Map<String, SchemaField> schemaFieldMap;

    RedisMetadataFilterMapper(Map<String, SchemaField> schemaFieldMap) {
        this.schemaFieldMap = schemaFieldMap;
    }

    String mapToFilter(Filter filter) {
        if (filter == null) {
            return "(*)";
        }
        if (filter instanceof IsEqualTo) {
            IsEqualTo isEqualTo = (IsEqualTo)filter;
            return this.mapEqual(isEqualTo);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo isNotEqualTo = (IsNotEqualTo)filter;
            return this.mapNotEqual(isNotEqualTo);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan isGreaterThan = (IsGreaterThan)filter;
            return this.mapGreaterThan(isGreaterThan);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo isGreaterThanOrEqualTo = (IsGreaterThanOrEqualTo)filter;
            return this.mapGreaterThanOrEqual(isGreaterThanOrEqualTo);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan isLessThan = (IsLessThan)filter;
            return this.mapLessThan(isLessThan);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo isLessThanOrEqualTo = (IsLessThanOrEqualTo)filter;
            return this.mapLessThanOrEqual(isLessThanOrEqualTo);
        }
        if (filter instanceof IsIn) {
            IsIn isIn = (IsIn)filter;
            return this.mapIn(isIn);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn isNotIn = (IsNotIn)filter;
            return this.mapNotIn(isNotIn);
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return this.mapAnd(and);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return this.mapNot(not);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return this.mapOr(or);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    String mapEqual(IsEqualTo filter) {
        return this.doMapEqual(filter.key(), filter.comparisonValue());
    }

    String mapNotEqual(IsNotEqualTo filter) {
        return this.doMapNot(this.doMapEqual(filter.key(), filter.comparisonValue()));
    }

    String mapGreaterThan(IsGreaterThan filter) {
        Numeric value = Numeric.constructNumeric(filter.comparisonValue(), true);
        return this.doMapCompare(filter.key(), value.toString(), Numeric.POSITIVE_INFINITY.toString());
    }

    String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo filter) {
        Numeric value = Numeric.constructNumeric(filter.comparisonValue(), false);
        return this.doMapCompare(filter.key(), value.toString(), Numeric.POSITIVE_INFINITY.toString());
    }

    String mapLessThan(IsLessThan filter) {
        Numeric value = Numeric.constructNumeric(filter.comparisonValue(), true);
        return this.doMapCompare(filter.key(), Numeric.NEGATIVE_INFINITY.toString(), value.toString());
    }

    String mapLessThanOrEqual(IsLessThanOrEqualTo filter) {
        Numeric value = Numeric.constructNumeric(filter.comparisonValue(), false);
        return this.doMapCompare(filter.key(), Numeric.NEGATIVE_INFINITY.toString(), value.toString());
    }

    String mapIn(IsIn filter) {
        return this.doMapIn(filter.key(), filter.comparisonValues());
    }

    String mapNotIn(IsNotIn filter) {
        return this.doMapNot(this.doMapIn(filter.key(), filter.comparisonValues()));
    }

    String mapAnd(And filter) {
        return "(" + this.mapToFilter(filter.left()) + " " + this.mapToFilter(filter.right()) + ")";
    }

    String mapNot(Not filter) {
        return this.doMapNot(this.mapToFilter(filter.expression()));
    }

    String mapOr(Or filter) {
        return "(" + this.mapToFilter(filter.left()) + OR_DELIMITER + this.mapToFilter(filter.right()) + ")";
    }

    private String doMapEqual(String key, Object value) {
        SchemaField fieldType = this.schemaFieldMap.getOrDefault(key, (SchemaField)TagField.of((String)key));
        String keyPrefix = this.toKeyPrefix(key);
        if (fieldType instanceof NumericField) {
            return keyPrefix + Boundary.NUMERIC_BOUNDARY.toSingleString(value);
        }
        if (fieldType instanceof TagField) {
            return keyPrefix + Boundary.TAG_BOUNDARY.toSingleString(value);
        }
        if (fieldType instanceof TextField) {
            return keyPrefix + Boundary.TEXT_BOUNDARY.toSingleString(value);
        }
        throw new UnsupportedOperationException("Unsupported field type: " + String.valueOf(fieldType));
    }

    private String doMapCompare(String key, String leftValue, String rightValue) {
        SchemaField fieldType = this.schemaFieldMap.getOrDefault(key, (SchemaField)TextField.of((String)key));
        if (fieldType instanceof NumericField) {
            return this.toKeyPrefix(key) + Boundary.NUMERIC_BOUNDARY.toRangeString(leftValue, rightValue);
        }
        throw new UnsupportedOperationException("Redis do not support non-Numeric range search, fieldType: " + String.valueOf(fieldType));
    }

    private String doMapIn(String key, Collection<?> values) {
        SchemaField fieldType = this.schemaFieldMap.getOrDefault(key, (SchemaField)TagField.of((String)key));
        String keyPrefix = this.toKeyPrefix(key);
        if (fieldType instanceof TagField) {
            String inFilter = values.stream().map(Object::toString).collect(Collectors.joining(OR_DELIMITER));
            return keyPrefix + Boundary.TAG_BOUNDARY.toSingleString(inFilter);
        }
        if (fieldType instanceof TextField) {
            String inFilter = values.stream().map(Boundary.TEXT_BOUNDARY::toSingleString).collect(Collectors.joining(OR_DELIMITER));
            return keyPrefix + Boundary.TEXT_IN_BOUNDARY.toSingleString(inFilter);
        }
        throw new UnsupportedOperationException("Redis do not support NumericType \"in\" search, fieldType: " + String.valueOf(fieldType));
    }

    private String doMapNot(String filter) {
        return String.format("(%s%s)", NOT_PREFIX, filter);
    }

    private String toKeyPrefix(String key) {
        return FILTER_PREFIX + key + ":";
    }

    static class Numeric {
        static final Numeric POSITIVE_INFINITY = new Numeric(Double.POSITIVE_INFINITY, true);
        static final Numeric NEGATIVE_INFINITY = new Numeric(Double.NEGATIVE_INFINITY, true);
        private static final String INFINITY = "inf";
        private static final String MINUS_INFINITY = "-inf";
        private static final String INCLUSIVE_FORMAT = "%s";
        private static final String EXCLUSIVE_FORMAT = "(%s";
        private final Object value;
        private final boolean exclusive;

        Numeric(Object value, boolean exclusive) {
            this.value = value;
            this.exclusive = exclusive;
        }

        static Numeric constructNumeric(Object value, boolean exclusive) {
            return new Numeric(value, exclusive);
        }

        public String toString() {
            if (this == POSITIVE_INFINITY) {
                return INFINITY;
            }
            if (this == NEGATIVE_INFINITY) {
                return MINUS_INFINITY;
            }
            return String.format(this.formatString(), this.value);
        }

        private String formatString() {
            if (this.exclusive) {
                return EXCLUSIVE_FORMAT;
            }
            return INCLUSIVE_FORMAT;
        }
    }

    static class Boundary {
        static final Boundary TAG_BOUNDARY = new Boundary("{", "}");
        static final Boundary TEXT_BOUNDARY = new Boundary("\"", "\"");
        static final Boundary TEXT_IN_BOUNDARY = new Boundary("(", ")");
        static final Boundary NUMERIC_BOUNDARY = new Boundary("[", "]");
        private final String left;
        private final String right;

        Boundary(String left, String right) {
            this.left = left;
            this.right = right;
        }

        String toSingleString(Object value) {
            return String.format("%s%s%s", this.left, value, this.right);
        }

        String toRangeString(Object leftValue, Object rightValue) {
            return String.format("%s%s %s%s", this.left, leftValue, rightValue, this.right);
        }
    }
}

