/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.community.model.dashscope.QwenChatRequestParameters;
import dev.langchain4j.community.model.dashscope.QwenChatResponseMetadata;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.spi.QwenChatModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.spi.ServiceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class QwenChatModel
implements ChatLanguageModel {
    private final QwenChatRequestParameters defaultRequestParameters;
    private final String apiKey;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final boolean isMultimodalModel;
    private final List<ChatModelListener> listeners;
    private Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer = p -> {};
    private Consumer<MultiModalConversationParam.MultiModalConversationParamBuilder<?, ?>> multimodalConversationParamCustomizer = p -> {};

    protected QwenChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens, List<ChatModelListener> listeners, ChatRequestParameters defaultRequestParameters, Boolean isMultimodalModel) {
        QwenChatRequestParameters qwenChatRequestParameters;
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        ChatRequestParameters commonParameters = defaultRequestParameters != null ? defaultRequestParameters : DefaultChatRequestParameters.builder().build();
        QwenChatRequestParameters qwenParameters = defaultRequestParameters instanceof QwenChatRequestParameters ? (qwenChatRequestParameters = (QwenChatRequestParameters)defaultRequestParameters) : QwenChatRequestParameters.builder().build();
        Double temperatureParameter = Objects.isNull(temperature) ? null : Double.valueOf(temperature.doubleValue());
        Double frequencyPenaltyParameter = QwenHelper.repetitionPenaltyToFrequencyPenalty(repetitionPenalty);
        String modelNameParameter = (String)Utils.getOrDefault((Object)modelName, (Object)commonParameters.modelName());
        this.apiKey = apiKey;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        isMultimodalModel = (Boolean)Utils.getOrDefault((Object)isMultimodalModel, (Object)QwenHelper.isMultimodalModel(modelNameParameter));
        this.isMultimodalModel = isMultimodalModel;
        this.defaultRequestParameters = ((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)((QwenChatRequestParameters.Builder)QwenChatRequestParameters.builder().modelName(modelNameParameter)).temperature((Double)Utils.getOrDefault((Object)temperatureParameter, (Object)commonParameters.temperature()))).topP((Double)Utils.getOrDefault((Object)topP, (Object)commonParameters.topP()))).topK((Integer)Utils.getOrDefault((Object)topK, (Object)commonParameters.topK()))).frequencyPenalty((Double)Utils.getOrDefault((Object)frequencyPenaltyParameter, (Object)commonParameters.frequencyPenalty()))).presencePenalty(commonParameters.presencePenalty())).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxTokens, (Object)commonParameters.maxOutputTokens()))).stopSequences((List)Utils.getOrDefault(stops, () -> Utils.copyIfNotNull((List)commonParameters.stopSequences())))).toolSpecifications(Utils.copyIfNotNull((List)commonParameters.toolSpecifications()))).toolChoice(commonParameters.toolChoice())).responseFormat(commonParameters.responseFormat())).seed((Integer)Utils.getOrDefault((Object)seed, (Object)qwenParameters.seed())).enableSearch((Boolean)Utils.getOrDefault((Object)enableSearch, (Object)qwenParameters.enableSearch())).searchOptions(qwenParameters.searchOptions()).translationOptions(qwenParameters.translationOptions()).vlHighResolutionImages(qwenParameters.vlHighResolutionImages()).custom(Utils.copyIfNotNull(qwenParameters.custom())).build();
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = isMultimodalModel != false ? new MultiModalConversation() : null;
            this.generation = isMultimodalModel != false ? null : new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = isMultimodalModel != false ? new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl) : null;
            this.generation = isMultimodalModel != false ? null : new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = isMultimodalModel != false ? new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl) : null;
            this.generation = isMultimodalModel != false ? null : new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    private ChatResponse generateByNonMultimodalModel(ChatRequest chatRequest) {
        GenerationParam param = QwenHelper.toGenerationParam(this.apiKey, chatRequest, this.generationParamCustomizer, false);
        try {
            GenerationResult result = this.generation.call((HalfDuplexServiceParam)param);
            return ChatResponse.builder().aiMessage(QwenHelper.aiMessageFrom(result)).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(result.getRequestId())).modelName(param.getModel())).tokenUsage(QwenHelper.tokenUsageFrom(result))).finishReason(QwenHelper.finishReasonFrom(result))).searchInfo(QwenHelper.convertSearchInfo(result.getOutput().getSearchInfo())).build()).build();
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChatResponse generateByMultimodalModel(ChatRequest chatRequest) {
        MultiModalConversationParam param = QwenHelper.toMultiModalConversationParam(this.apiKey, chatRequest, this.multimodalConversationParamCustomizer, false);
        try {
            MultiModalConversationResult result = this.conv.call(param);
            return ChatResponse.builder().aiMessage(AiMessage.from((String)QwenHelper.answerFrom(result))).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(result.getRequestId())).modelName(param.getModel())).tokenUsage(QwenHelper.tokenUsageFrom(result))).finishReason(QwenHelper.finishReasonFrom(result))).build()).build();
        }
        catch (NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UploadFileException e) {
            throw new IllegalStateException(e);
        }
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        return this.isMultimodalModel ? this.generateByMultimodalModel(chatRequest) : this.generateByNonMultimodalModel(chatRequest);
    }

    public QwenChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public void setGenerationParamCustomizer(Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer) {
        this.generationParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(generationParamCustomizer, (String)"generationParamConsumer");
    }

    public void setMultimodalConversationParamCustomizer(Consumer<MultiModalConversationParam.MultiModalConversationParamBuilder<?, ?>> multimodalConversationParamCustomizer) {
        this.multimodalConversationParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(multimodalConversationParamCustomizer, (String)"multimodalConversationParamCustomizer");
    }

    public static QwenChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenChatModelBuilderFactory factory = (QwenChatModelBuilderFactory)iterator.next();
            return (QwenChatModelBuilder)factory.get();
        }
        return new QwenChatModelBuilder();
    }

    public static class QwenChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;
        private List<ChatModelListener> listeners;
        private ChatRequestParameters defaultRequestParameters;
        private Boolean isMultimodalModel;

        public QwenChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QwenChatModelBuilder defaultRequestParameters(ChatRequestParameters defaultRequestParameters) {
            this.defaultRequestParameters = defaultRequestParameters;
            return this;
        }

        public QwenChatModelBuilder isMultimodalModel(Boolean isMultimodalModel) {
            this.isMultimodalModel = isMultimodalModel;
            return this;
        }

        public QwenChatModel build() {
            return new QwenChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens, this.listeners, this.defaultRequestParameters, this.isMultimodalModel);
        }

        public String toString() {
            return "QwenStreamingChatModelBuilder{baseUrl=" + Utils.quoted((Object)this.baseUrl) + ", modelName='" + Utils.quoted((Object)this.modelName) + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch=" + this.enableSearch + ", seed=" + this.seed + ", repetitionPenalty=" + this.repetitionPenalty + ", temperature=" + this.temperature + ", stops=" + String.valueOf(this.stops) + ", maxTokens=" + this.maxTokens + ", listeners=" + String.valueOf(this.listeners) + ", defaultRequestParameters=" + String.valueOf(this.defaultRequestParameters) + "}";
        }
    }
}

