/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;

public class AnthropicChatModel
implements ChatLanguageModel {
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final int maxRetries;

    private AnthropicChatModel(String baseUrl, String apiKey, String version, String beta, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).beta((String)Utils.getOrDefault((Object)beta, (Object)"tools-2024-04-04"))).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)AnthropicChatModelName.CLAUDE_3_HAIKU_20240307.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static AnthropicChatModel withApiKey(String apiKey) {
        return AnthropicChatModel.builder().apiKey(apiKey).build();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        AnthropicCreateMessageRequest request = AnthropicCreateMessageRequest.builder().model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(messages)).system(AnthropicMapper.toAnthropicSystemPrompt(messages)).maxTokens(this.maxTokens).stopSequences(this.stopSequences).stream(false).temperature(this.temperature).topP(this.topP).topK(this.topK).tools(AnthropicMapper.toAnthropicTools(toolSpecifications)).build();
        AnthropicCreateMessageResponse response = (AnthropicCreateMessageResponse)RetryUtils.withRetry(() -> this.client.createMessage(request), (int)this.maxRetries);
        return Response.from((Object)AnthropicMapper.toAiMessage(response.content), (TokenUsage)AnthropicMapper.toTokenUsage(response.usage), (FinishReason)AnthropicMapper.toFinishReason(response.stopReason));
    }

    public static AnthropicChatModelBuilder builder() {
        return new AnthropicChatModelBuilder();
    }

    public static class AnthropicChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String version;
        private String beta;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        public AnthropicChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        AnthropicChatModelBuilder() {
        }

        public AnthropicChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        public AnthropicChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public AnthropicChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public AnthropicChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicChatModel build() {
            return new AnthropicChatModel(this.baseUrl, this.apiKey, this.version, this.beta, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "AnthropicChatModel.AnthropicChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", version=" + this.version + ", beta=" + this.beta + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", maxTokens=" + this.maxTokens + ", stopSequences=" + this.stopSequences + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

