/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.Catalog;
import dev.equo.ide.IdeHook;
import dev.equo.ide.IdeHookWelcome;
import dev.equo.ide.WorkspaceInit;
import dev.equo.solstice.p2.P2Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CatalogDsl {
    protected final Catalog catalog;
    @Nullable
    private final CatalogDsl addedAsTransitiveOf;
    @Nullable
    private String p2AndMavenOverride;
    private final WorkspaceInit workspaceInit = new WorkspaceInit();

    protected CatalogDsl(Catalog catalog) {
        this(catalog, null);
    }

    private CatalogDsl(Catalog catalog, @Nullable CatalogDsl addedAsTransitiveOf) {
        this.catalog = catalog;
        this.addedAsTransitiveOf = addedAsTransitiveOf;
    }

    protected WorkspaceInit workspaceInit() {
        return this.workspaceInit;
    }

    protected List<IdeHook> ideHooks() {
        return List.of();
    }

    private String url() {
        return this.catalog.getUrlForOverride(this.p2AndMavenOverride);
    }

    private List<String> installs() {
        if (!this.catalog.isPureMaven()) {
            return this.catalog.getTargetsFor(this.p2AndMavenOverride);
        }
        if (this.p2AndMavenOverride == null) {
            String version = this.catalog.versions.getAndWarn(this.catalog);
            return CatalogDsl.replaceV(this.catalog.getTargetsFor(null), version);
        }
        if (this.p2AndMavenOverride.contains(":")) {
            return Arrays.asList(this.p2AndMavenOverride.split(","));
        }
        return CatalogDsl.replaceV(this.catalog.getTargetsFor(this.p2AndMavenOverride), this.p2AndMavenOverride);
    }

    private static List<String> replaceV(List<String> list, String replaceWith) {
        return list.stream().map(str -> str.replace("${VERSION}", replaceWith)).collect(Collectors.toList());
    }

    private Map<String, P2Model.Filter> filters() {
        return this.catalog.getFiltersFor(this.p2AndMavenOverride);
    }

    protected void setUrlOverride(String p2AndMavenOverride) {
        this.p2AndMavenOverride = p2AndMavenOverride;
    }

    void syncUrlWith(CatalogDsl other) {
        if (!this.catalog.getP2UrlTemplate().equals(other.catalog.getP2UrlTemplate()) || this.catalog.isPureMaven()) {
            return;
        }
        if (Objects.equals(this.p2AndMavenOverride, other.p2AndMavenOverride)) {
            return;
        }
        if (this.p2AndMavenOverride == null) {
            this.p2AndMavenOverride = other.p2AndMavenOverride;
        } else if (other.p2AndMavenOverride == null) {
            other.p2AndMavenOverride = this.p2AndMavenOverride;
        } else {
            throw new IllegalArgumentException(this.catalog.getName() + " " + other.catalog.getName() + " must have the exact same URL, but\n" + this.urlReasoning() + "\n" + other.urlReasoning());
        }
    }

    private String urlReasoning() {
        if (this.addedAsTransitiveOf != null) {
            return this.catalog.getName() + " is using " + this.url() + " (was added automatically as a transitive of " + this.addedAsTransitiveOf.catalog.getName() + ")";
        }
        return this.catalog.getName() + " is using " + this.url();
    }

    public static class TransitiveAwareList<T extends CatalogDsl> {
        private List<CatalogDsl> insertionOrder = new ArrayList<CatalogDsl>();
        private final TreeMap<Catalog, CatalogDsl> catalogEntries = new TreeMap();

        public void add(T dsl) {
            this.insertionOrder.add((CatalogDsl)dsl);
            CatalogDsl existing = this.catalogEntries.get(((CatalogDsl)dsl).catalog);
            if (existing != null) {
                if (existing.addedAsTransitiveOf != null) {
                    throw new IllegalArgumentException(((CatalogDsl)dsl).catalog.getName() + " was already added as a transitive dependency of " + existing.addedAsTransitiveOf.catalog.getName() + ".\nYou can fix this by moving the <" + ((CatalogDsl)dsl).catalog.getName() + "> block above the <" + existing.addedAsTransitiveOf.catalog.getName() + "> block.");
                }
                throw new IllegalArgumentException("You can only add " + ((CatalogDsl)dsl).catalog.getName() + " once.");
            }
            this.catalogEntries.put(((CatalogDsl)dsl).catalog, (CatalogDsl)dsl);
            for (Catalog required : ((CatalogDsl)dsl).catalog.getRequires()) {
                CatalogDsl transitive = this.addAsTransitiveOf(required, (CatalogDsl)dsl);
                transitive.syncUrlWith((CatalogDsl)dsl);
            }
        }

        private CatalogDsl addAsTransitiveOf(Catalog transitive, CatalogDsl originalRequest) {
            CatalogDsl dsl = this.catalogEntries.get(transitive);
            if (dsl == null) {
                dsl = new CatalogDsl(transitive, originalRequest);
                this.catalogEntries.put(transitive, dsl);
                this.insertionOrder.add(dsl);
            }
            for (Catalog required : transitive.getRequires()) {
                CatalogDsl transitiveDsl = this.addAsTransitiveOf(required, originalRequest);
                transitiveDsl.syncUrlWith(dsl);
            }
            return dsl;
        }

        @Deprecated
        public void putInto(P2Model model, IdeHook.List hooks) {
            this.putInto(model, hooks, new WorkspaceInit());
        }

        public void putInto(P2Model model, IdeHook.List hooks, WorkspaceInit workspace) {
            for (CatalogDsl dsl2 : this.catalogEntries.values()) {
                if (dsl2.catalog.isPureMaven()) {
                    model.getPureMaven().addAll(dsl2.installs());
                } else {
                    model.addP2Repo(dsl2.url());
                    model.getInstall().addAll(dsl2.installs());
                    dsl2.filters().forEach(model::addFilterAndValidate);
                }
                hooks.addAll(dsl2.ideHooks());
                workspace.copyAllFrom(dsl2.workspaceInit());
            }
            String perspective = this.insertionOrder.stream().map(dsl -> Catalog.defaultPerspectiveFor(dsl.catalog)).filter(Objects::nonNull).findFirst().orElse(null);
            if (perspective != null) {
                IdeHookWelcome welcomeHook = hooks.stream().filter(hook -> hook instanceof IdeHookWelcome).findFirst().orElse(null);
                if (welcomeHook == null) {
                    welcomeHook = new IdeHookWelcome();
                    hooks.add(welcomeHook);
                }
                if (welcomeHook.perspective() == null) {
                    welcomeHook.perspective(perspective);
                }
            }
        }
    }
}

