/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.okhttp;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogOkHttpInterceptor
implements Interceptor {
    private final Logger log = LoggerFactory.getLogger(TLogOkHttpInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            builder.header("tlogTraceId", traceId);
            builder.header("tlogSpanId", SpanIdGenerator.generateNextSpanId());
            builder.header("preIvkApp", appName);
            builder.header("preIvkHost", LocalhostUtil.getHostName());
            builder.header("preIp", LocalhostUtil.getHostIp());
        } else {
            this.log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return chain.proceed(builder.build());
    }
}

