/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils.support;

import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PrivateKey;
import java.util.HashMap;

public final class CashierSupport {
    private static final String CASHIER_URL = "https://cash.yeepay.com/cashier/std";

    public static String getPayUrl(PrivateKey privateKey, String appKey, String merchantNo, String token) {
        return CashierSupport.getPayUrl(privateKey, appKey, merchantNo, token, CASHIER_URL);
    }

    public static String getPayUrl(PrivateKey privateKey, String appKey, String merchantNo, String token, String cashierUrl) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appKey", appKey);
        params.put("merchantNo", merchantNo);
        params.put("token", token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("directPayType", "");
        params.put("cardType", "");
        params.put("userNo", "2372373273278238");
        params.put("userType", "USER_ID");
        String[] CASHIER = new String[]{"appKey", "merchantNo", "token", "timestamp", "directPayType", "cardType", "userNo", "userType"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < CASHIER.length; ++i) {
            String name = CASHIER[i];
            String value = (String)params.get(name);
            if (i != 0) {
                sb.append("&");
            }
            sb.append(name).append("=").append(value);
        }
        String sign = CashierSupport.signature(sb.toString(), privateKey);
        return cashierUrl + "?sign=" + sign + "&" + sb;
    }

    private static String signature(String plainText, PrivateKey privateKey) {
        CertTypeEnum certType = CashierSupport.resolveCertType(privateKey);
        return YopSignProcessorFactory.getSignProcessor(certType.name()).sign(plainText, new PKICredentialsItem(privateKey, null, certType));
    }

    private static CertTypeEnum resolveCertType(PrivateKey privateKey) {
        switch (privateKey.getAlgorithm()) {
            case "RSA": {
                return CertTypeEnum.RSA2048;
            }
            case "EC": {
                return CertTypeEnum.SM2;
            }
        }
        throw new RuntimeException("sign algorithm(" + privateKey.getAlgorithm() + ") not supported");
    }
}

