/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.Protocol;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final BitSet URI_UNRESERVED_CHARACTERS;
    private static final String[] PERCENT_ENCODED_STRINGS;
    private static final Joiner queryStringJoiner;
    private static final boolean HTTP_VERBOSE;

    public static String normalizePath(String path) {
        return HttpUtils.normalize(path).replace("%2F", "/");
    }

    public static String normalize(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            for (byte b : value.getBytes(DEFAULT_ENCODING)) {
                if (URI_UNRESERVED_CHARACTERS.get(b & 0xFF)) {
                    builder.append((char)b);
                    continue;
                }
                builder.append(PERCENT_ENCODED_STRINGS[b & 0xFF]);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateHostHeader(URI uri) {
        String host = uri.getHost();
        if (HttpUtils.isUsingNonDefaultPort(uri)) {
            host = host + ":" + uri.getPort();
        }
        return host;
    }

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port <= 0) {
            return false;
        }
        if (scheme.equals(Protocol.HTTP.toString())) {
            return port != Protocol.HTTP.getDefaultPort();
        }
        if (scheme.equals(Protocol.HTTPS.toString())) {
            return port != Protocol.HTTPS.getDefaultPort();
        }
        return false;
    }

    public static String getCanonicalQueryString(Map<String, List<String>> parameters, boolean forSignature) {
        if (parameters.isEmpty()) {
            return "";
        }
        ArrayList parameterStrings = Lists.newArrayList();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (forSignature && "Authorization".equalsIgnoreCase(entry.getKey())) continue;
            String key = entry.getKey();
            Preconditions.checkNotNull((Object)key, (Object)"parameter key should not be null");
            List<String> value = entry.getValue();
            if (value == null) {
                if (forSignature) {
                    parameterStrings.add(HttpUtils.normalize(key) + '=');
                    continue;
                }
                parameterStrings.add(HttpUtils.normalize(key));
                continue;
            }
            for (String item : value) {
                parameterStrings.add(HttpUtils.normalize(key) + '=' + HttpUtils.normalize(item));
            }
        }
        Collections.sort(parameterStrings);
        return queryStringJoiner.join((Iterable)parameterStrings);
    }

    public static URI appendUri(URI baseUri, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(baseUri.toASCIIString());
        for (String path : pathComponents) {
            if (path == null || path.length() <= 0) continue;
            if ((path = HttpUtils.normalizePath(path)).startsWith("/")) {
                if (builder.charAt(builder.length() - 1) == '/') {
                    builder.setLength(builder.length() - 1);
                }
            } else if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(path);
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    public static void printRequest(HttpRequestBase request) {
        if (!HTTP_VERBOSE) {
            return;
        }
        System.out.println("\n-------------> ");
        System.out.println(request.getRequestLine());
        for (Header h : request.getAllHeaders()) {
            System.out.println(h.getName() + " : " + h.getValue());
        }
        RequestConfig config = request.getConfig();
        if (config != null) {
            System.out.println("getConnectionRequestTimeout: " + config.getConnectionRequestTimeout());
            System.out.println("getConnectTimeout: " + config.getConnectTimeout());
            System.out.println("getCookieSpec: " + config.getCookieSpec());
            System.out.println("getLocalAddress: " + config.getLocalAddress());
        }
    }

    public static void printResponse(CloseableHttpResponse response) {
        Header[] heads;
        if (!HTTP_VERBOSE) {
            return;
        }
        System.out.println("\n<------------- ");
        StatusLine status = response.getStatusLine();
        System.out.println(status.getStatusCode() + " - " + status.getReasonPhrase());
        for (Header h : heads = response.getAllHeaders()) {
            System.out.println(h.getName() + " : " + h.getValue());
        }
    }

    public static boolean usePayloadForQueryParameters(Request<? extends BaseRequest> request) {
        boolean requestIsPOST = HttpMethodName.POST.equals((Object)request.getHttpMethod());
        boolean requestHasNoPayload = request.getContent() == null;
        return requestIsPOST && requestHasNoPayload;
    }

    public static String encodeParameters(Request<? extends BaseRequest> request, Boolean forSignature) {
        Map<String, List<String>> requestParams;
        Map<String, List<String>> map = requestParams = BooleanUtils.isTrue((Boolean)forSignature) ? new TreeMap<String, List<String>>(request.getParameters()) : Collections.unmodifiableMap(request.getParameters());
        if (requestParams.isEmpty()) {
            return null;
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, List<String>> entry : requestParams.entrySet()) {
            String parameterName = entry.getKey();
            for (String value : entry.getValue()) {
                try {
                    nameValuePairs.add(new BasicNameValuePair(parameterName, BooleanUtils.isTrue((Boolean)forSignature) ? value : URLEncoder.encode(value, DEFAULT_ENCODING)));
                }
                catch (UnsupportedEncodingException e) {
                    throw new YopClientException("unsupported charset.", e);
                }
            }
        }
        return URLEncodedUtils.format(nameValuePairs, (String)DEFAULT_ENCODING);
    }

    static {
        int i;
        URI_UNRESERVED_CHARACTERS = new BitSet();
        PERCENT_ENCODED_STRINGS = new String[256];
        queryStringJoiner = Joiner.on((char)'&');
        HTTP_VERBOSE = Boolean.parseBoolean(System.getProperty("yop.sdk.http", "false"));
        for (i = 97; i <= 122; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URI_UNRESERVED_CHARACTERS.set(i);
        }
        URI_UNRESERVED_CHARACTERS.set(45);
        URI_UNRESERVED_CHARACTERS.set(46);
        URI_UNRESERVED_CHARACTERS.set(95);
        URI_UNRESERVED_CHARACTERS.set(126);
        for (i = 0; i < PERCENT_ENCODED_STRINGS.length; ++i) {
            HttpUtils.PERCENT_ENCODED_STRINGS[i] = String.format("%%%02X", i);
        }
    }
}

