/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class YopRequestMarshaller
implements RequestMarshaller<YopRequest> {
    private static final YopRequestMarshaller INSTANCE = new YopRequestMarshaller();

    public static YopRequestMarshaller getInstance() {
        return INSTANCE;
    }

    @Override
    public Request<YopRequest> marshall(YopRequest request) {
        String[] pathParts = StringUtils.split((String)request.getApiUri(), (String)"/");
        DefaultRequest<YopRequest> internalRequest = new DefaultRequest<YopRequest>(request, pathParts[2]);
        if (StringUtils.equals((CharSequence)pathParts[0], (CharSequence)"yos")) {
            internalRequest.assignYos();
        }
        internalRequest.setResourcePath(request.getApiUri());
        internalRequest.setHttpMethod(HttpMethodName.valueOf(request.getHttpMethod().toUpperCase()));
        Map<String, String> customerHeaders = request.getRequestConfig().getCustomRequestHeaders();
        if (customerHeaders != null) {
            for (String string : customerHeaders.keySet()) {
                internalRequest.addHeader(string, customerHeaders.get(string));
            }
        }
        internalRequest.addHeader("x-yop-request-id", UUID.randomUUID().toString());
        if (!request.getParameters().isEmpty()) {
            for (Map.Entry entry : request.getParameters().asMap().entrySet()) {
                internalRequest.addParameters((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
            }
        }
        if (!request.getMultipartFiles().isEmpty()) {
            for (Map.Entry entry : request.getMultipartFiles().asMap().entrySet()) {
                String name = (String)entry.getKey();
                for (Object value : (Collection)entry.getValue()) {
                    if (value instanceof File) {
                        internalRequest.addMultiPartFile(name, (File)value);
                        continue;
                    }
                    if (value instanceof InputStream) {
                        internalRequest.addMultiPartFile(name, (InputStream)value);
                        continue;
                    }
                    throw new YopClientException("Unexpected file parameter type, name:" + name + ", type:" + value.getClass() + ".");
                }
            }
        } else if (request.getContent() != null) {
            if (request.getContent() instanceof String) {
                byte[] contentBytes = ((String)request.getContent()).getBytes(YopConstants.DEFAULT_CHARSET);
                internalRequest.setContent(RestartableInputStream.wrap(contentBytes));
                internalRequest.addHeader("Content-Type", "application/json");
                internalRequest.addHeader("Content-Length", String.valueOf(contentBytes.length));
            } else if (request.getContent() instanceof InputStream) {
                internalRequest.setContent((InputStream)request.getContent());
            }
        } else {
            internalRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        return internalRequest;
    }
}

