/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security.rsa;

import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.Encryption;
import com.yeepay.yop.sdk.security.Signer;
import com.yeepay.yop.sdk.security.rsa.RSA;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSA2048
implements Encryption<KeyPair>,
Signer {
    @Override
    public KeyPair generateRandomKey() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        return kpg.genKeyPair();
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] key) {
        try {
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(key));
            return RSA.encrypt(plainText, publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new YopClientException("No such algorithm.", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] key) {
        try {
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(key));
            return RSA.decrypt(cipherText, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new YopClientException("No such algorithm.", e);
        }
    }

    @Override
    public byte[] sign(PrivateKey privateKey, byte[] plaintText) {
        return RSA.sign(plaintText, privateKey, DigestAlgEnum.SHA256);
    }

    @Override
    public boolean verifySign(PublicKey publicKey, byte[] plaintText, byte[] signature) {
        return RSA.verifySign(plaintText, signature, publicKey, DigestAlgEnum.SHA256);
    }
}

