/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security;

import com.google.common.collect.ImmutableMap;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class YopSignUtils {
    private static final String SPLIT_CHAR = "$";
    private static Map<String, CertTypeEnum> digestAlgANdCertTypeMap = new ImmutableMap.Builder().put((Object)"SHA256", (Object)CertTypeEnum.RSA2048).put((Object)"SM3", (Object)CertTypeEnum.SM2).build();

    public static void verify(String data, String signature, String appKey) {
        YopSignUtils.validSignature(signature);
        String[] args = StringUtils.split((String)signature, (String)SPLIT_CHAR);
        CertTypeEnum certType = digestAlgANdCertTypeMap.get(args[1]);
        String serialNo = args.length == 4 ? args[3] : (CertTypeEnum.SM2.equals((Object)certType) ? "sm" : "rsa");
        YopPlatformCredentials yopPlatformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getYopPlatformCredentials(appKey, serialNo);
        if (null == yopPlatformCredentials) {
            throw new YopClientException("can not load platform cert");
        }
        YopSignUtils.verify(data, signature, yopPlatformCredentials.getPublicKey(certType));
    }

    public static void verify(String data, String signature, PublicKey publicKey) {
        YopSignUtils.validSignature(signature);
        String[] args = signature.split("\\$");
        YopSignProcessor yopSignProcessor = YopSignProcessorFactory.getSignProcessor(digestAlgANdCertTypeMap.get(args[1]).name());
        if (null == yopSignProcessor) {
            throw new YopClientException("unsupported certType");
        }
        PKICredentialsItem pkiCredentialsItem = new PKICredentialsItem(null, publicKey, digestAlgANdCertTypeMap.get(args[1]));
        if (!yopSignProcessor.verify(data, args[0], pkiCredentialsItem)) {
            throw new YopClientException("verify fail!");
        }
    }

    public static String sign(String data, String certType, String appKey) {
        YopPKICredentials yopCredentials = (YopPKICredentials)YopCredentialsProviderRegistry.getProvider().getCredentials(appKey, certType);
        PKICredentialsItem pkiCredentialsItem = yopCredentials.getCredential();
        return YopSignUtils.sign(data, certType, pkiCredentialsItem.getPrivateKey());
    }

    public static String sign(String data, String certType, PrivateKey privateKey) {
        YopSignProcessor yopSignProcessor = YopSignProcessorFactory.getSignProcessor(certType);
        if (null == yopSignProcessor) {
            throw new YopClientException("unsupported certType");
        }
        PKICredentialsItem pkiCredentialsItem = new PKICredentialsItem(privateKey, null, CertTypeEnum.parse(certType));
        return yopSignProcessor.sign(data, pkiCredentialsItem) + SPLIT_CHAR + yopSignProcessor.getDigestAlg();
    }

    private static void validSignature(String signature) {
        String[] args = signature.split("\\$");
        if (args.length != 2 && args.length != 4) {
            throw new YopClientException("illegal signature");
        }
        CertTypeEnum certType = digestAlgANdCertTypeMap.get(args[1]);
        if (certType == null) {
            throw new YopClientException("illegal signature");
        }
    }
}

