/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.security;

import java.util.HashMap;
import java.util.Map;

public enum CertTypeEnum {
    AES128("AES128", "AES\u7b97\u6cd5\uff0c\u5bc6\u94a5\u957f\u5ea6128", "AES", 128, 16, true),
    AES256("AES256", "AES\u7b97\u6cd5, \u5bc6\u94a5\u957f\u5ea6256", "AES", 256, 32, true),
    RSA2048("RSA2048", "RSA\u7b97\u6cd5, \u5bc6\u94a5\u957f\u5ea62048", "RSA", 2048, 294, false),
    SM2("SM2", "SM2\u7b97\u6cd5\uff0c\u5bc6\u94a5\u957f\u5ea6256", "SM2", 256, 32, false),
    SM4("SM4", "SM4\u7b97\u6cd5\uff0c\u5bc6\u94a5\u957f\u5ea6128", "SM2", 128, 16, true);

    private static final Map<String, CertTypeEnum> VALUE_MAP;
    private final String value;
    private final String displayName;
    private final String algorithm;
    private final int keySize;
    private final int encodedSize;
    private final boolean symmetric;

    private CertTypeEnum(String value, String displayName, String algorithm, int keySize, int encodedSize, boolean symmetric) {
        this.value = value;
        this.displayName = displayName;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.symmetric = symmetric;
        this.encodedSize = encodedSize;
    }

    public static CertTypeEnum parse(String value) {
        return VALUE_MAP.get(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public int getEncodedSize() {
        return this.encodedSize;
    }

    public static Map<String, CertTypeEnum> getValueMap() {
        return VALUE_MAP;
    }

    static {
        VALUE_MAP = new HashMap<String, CertTypeEnum>();
        for (CertTypeEnum item : CertTypeEnum.values()) {
            VALUE_MAP.put(item.value, item);
        }
    }
}

