/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.google.common.base.Preconditions;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RestartableFileInputStream
extends RestartableInputStream {
    private final File file;
    private FileInputStream input;

    public RestartableFileInputStream(File file) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null.");
        this.file = file;
        this.input = new FileInputStream(file);
    }

    @Override
    public void restart() {
        try {
            this.input.close();
            this.input = new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new YopClientException("Fail to restart.", e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

