/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.yop.sdk.internal.MarkableFileInputStream;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.checksum.CRC64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartFile
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final int EXT_READ_BUFFER_SIZE = 65536;
    private final CheckedInputStream inputStream;
    private final String fileName;

    public MultiPartFile(File file) throws IOException {
        this.inputStream = new CheckedInputStream(new FileInputStream(file), new CRC64());
        this.fileName = file.getName();
    }

    public MultiPartFile(InputStream in) throws IOException {
        Pair<String, CheckedInputStream> inputStreamPair = in instanceof FileInputStream ? MultiPartFile.getCheckedInputStreamPair((FileInputStream)in) : MultiPartFile.getCheckedInputStreamPair(in);
        this.fileName = (String)inputStreamPair.getLeft();
        this.inputStream = (CheckedInputStream)inputStreamPair.getRight();
    }

    public CheckedInputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(FileInputStream fileInputStream) throws IOException {
        MarkableFileInputStream in = new MarkableFileInputStream(fileInputStream);
        in.mark(0);
        String fileName = FileUtils.getFileName(in);
        in.reset();
        CheckedInputStream inputStream = new CheckedInputStream(in, new CRC64());
        return new ImmutablePair((Object)fileName, (Object)inputStream);
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(InputStream inputStream) throws IOException {
        byte[] extReadBuffer = new byte[65536];
        int totalRead = 0;
        int lastRead = inputStream.read(extReadBuffer);
        while (lastRead != -1 && (totalRead += lastRead) != 65536) {
            lastRead = inputStream.read(extReadBuffer, totalRead, 65536 - totalRead);
        }
        ByteArrayInputStream extReadIn = new ByteArrayInputStream(extReadBuffer, 0, totalRead);
        String fileName = FileUtils.getFileName(extReadIn);
        extReadIn.reset();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(extReadIn, inputStream);
        return new ImmutablePair((Object)fileName, (Object)new CheckedInputStream(sequenceInputStream, new CRC64()));
    }
}

