/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PublicKey;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSignatureCheckAnalyzer
implements HttpResponseAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSignatureCheckAnalyzer.class);
    private static final YopSignatureCheckAnalyzer INSTANCE = new YopSignatureCheckAnalyzer();

    public static YopSignatureCheckAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopSignatureCheckAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopResponseMetadata metadata = response.getMetadata();
        if (BooleanUtils.isTrue((Boolean)context.isSkipVerifySign()) || StringUtils.isBlank((CharSequence)metadata.getYopSign())) {
            return false;
        }
        PKICredentialsItem pkiCredentialsItem = this.getCredentialItem(context.getSignOptions(), context.getAppKey(), metadata.getYopCertSerialNo());
        if (null == pkiCredentialsItem) {
            throw new YopClientException("yop platform credentials not found");
        }
        YopPKICredentials credentials = new YopPKICredentials(context.getAppKey(), pkiCredentialsItem);
        context.getSigner().checkSignature(context.getResponse(), metadata.getYopSign(), credentials, context.getSignOptions());
        return false;
    }

    private PKICredentialsItem getCredentialItem(SignOptions signOptions, String appKey, String serialNo) {
        PublicKey publicKey;
        YopPlatformCredentials yopPlatformCredentials;
        CertTypeEnum certType;
        CertTypeEnum certTypeEnum = certType = "YOP-SM2-SM3".equals(signOptions.getProtocolPrefix()) ? CertTypeEnum.SM2 : CertTypeEnum.RSA2048;
        if (certType == CertTypeEnum.RSA2048) {
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                LOGGER.warn("rsa signed request not need serialNo:{}.", (Object)serialNo);
            }
            serialNo = "rsa";
        }
        if (null != (yopPlatformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getYopPlatformCredentials(appKey, serialNo)) && null != (publicKey = yopPlatformCredentials.getPublicKey(certType))) {
            return new PKICredentialsItem(null, yopPlatformCredentials.getPublicKey(certType), certType);
        }
        return null;
    }
}

