/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.yeepay.yop.sdk.auth.Encryptor;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.signer.YopSigner;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import java.io.IOException;
import java.io.Serializable;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpResponseHandleContext
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final String appKey;
    private final YopHttpResponse response;
    private final Request originRequest;
    private final YopSigner signer;
    private final SignOptions signOptions;
    private final Boolean needDecrypt;
    private final Encryptor encryptor;
    private final Boolean skipVerifySign;

    public HttpResponseHandleContext(CloseableHttpResponse httpResponse, Request originRequest, YopRequestConfig yopRequestConfig, ExecutionContext executionContext) throws IOException {
        this.appKey = originRequest.getHeaders().get("x-yop-appkey");
        this.response = new YopHttpResponse(httpResponse);
        this.originRequest = originRequest;
        this.signer = executionContext.getSigner();
        this.signOptions = executionContext.getSignOptions();
        this.needDecrypt = yopRequestConfig.getNeedEncrypt();
        this.encryptor = executionContext.getEncryptor();
        this.skipVerifySign = yopRequestConfig.getSkipVerifySign();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public YopHttpResponse getResponse() {
        return this.response;
    }

    public Request getOriginRequest() {
        return this.originRequest;
    }

    public YopSigner getSigner() {
        return this.signer;
    }

    public SignOptions getSignOptions() {
        return this.signOptions;
    }

    public Boolean isNeedDecrypt() {
        return this.needDecrypt;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public Boolean isSkipVerifySign() {
        return this.skipVerifySign;
    }
}

