/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.provider.file.support;

import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopServiceException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.rsa.RSAKeyUtils;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.Sm2CertUtils;
import com.yeepay.yop.sdk.utils.Sm2Utils;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;

public final class YopCertConfigUtils {
    public static PublicKey loadPublicKey(YopCertConfig yopCertConfig) {
        PublicKey publicKey;
        if (null == yopCertConfig.getStoreType()) {
            throw new YopServiceException("Can't init YOP public key! Store type is error.");
        }
        switch (yopCertConfig.getStoreType()) {
            case STRING: {
                if (CertTypeEnum.RSA2048 == yopCertConfig.getCertType()) {
                    publicKey = RSAKeyUtils.string2PublicKey(yopCertConfig.getValue());
                    break;
                }
                publicKey = Sm2Utils.string2PublicKey(yopCertConfig.getValue());
                break;
            }
            case FILE_CER: {
                InputStream inputStream = FileUtils.getResourceAsStream(yopCertConfig.getValue());
                try {
                    X509Certificate x509Certificate = Sm2CertUtils.getX509Certificate(inputStream);
                    publicKey = x509Certificate.getPublicKey();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new RuntimeException("Not support cert store type.");
            }
        }
        return publicKey;
    }

    public static String loadPrivateKey(YopCertConfig yopCertConfig) {
        String privateKey = null;
        if (null == yopCertConfig.getStoreType()) {
            throw new YopServiceException("Can't init ISV private key! Store type is error.");
        }
        switch (yopCertConfig.getStoreType()) {
            case STRING: {
                try {
                    privateKey = yopCertConfig.getValue();
                    break;
                }
                catch (Exception ex) {
                    throw new YopServiceException("Failed to load private key form config file is error, " + yopCertConfig, ex);
                }
            }
            case FILE_P12: {
                try {
                    String pwd = (String)StringUtils.defaultIfEmpty((CharSequence)yopCertConfig.getPassword(), (CharSequence)"");
                    char[] password = pwd.toCharArray();
                    KeyStore keystore = KeyStore.getInstance("PKCS12", "BC");
                    keystore.load(FileUtils.getResourceAsStream(yopCertConfig.getValue()), password);
                    Enumeration<String> aliases = keystore.aliases();
                    Key key = null;
                    while (aliases.hasMoreElements() && !(key instanceof PrivateKey)) {
                        String keyAlias = aliases.nextElement();
                        key = keystore.getKey(keyAlias, password);
                    }
                    if (null == key) break;
                    privateKey = RSAKeyUtils.key2String(key);
                    break;
                }
                catch (Exception ex) {
                    throw new YopClientException("Config wrong for private_key, cert_config:" + yopCertConfig, ex);
                }
            }
            default: {
                throw new YopClientException("Config wrong for cert store_type not supported, " + (Object)((Object)yopCertConfig.getStoreType()));
            }
        }
        if (StringUtils.isEmpty((CharSequence)privateKey)) {
            throw new YopClientException("Config wrong for private_key, cert_config:" + yopCertConfig);
        }
        return privateKey;
    }
}

