/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.provider.file;

import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopFixedSdkConfigProvider;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.utils.BeanUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class YopFileSdkConfigProvider
extends YopFixedSdkConfigProvider {
    public static final String SDK_CONFIG_ENV_PROPERTY_KEY = "yop.sdk.config.env";
    public static final String SDK_CONFIG_DIR_PROPERTY_KEY = "yop.sdk.config.dir";
    public static final String SDK_CONFIG_FILE_PROPERTY_KEY = "yop.sdk.config.file";
    private static final String SDK_CONFIG_DIR = "config";
    private static final String DEFAULT_CONFIG_FILE = "config/yop_sdk_config_default.json";
    private Map<String, YopFileSdkConfig> sdkConfigs = new HashMap<String, YopFileSdkConfig>();

    @Override
    protected YopSdkConfig loadSdkConfig() {
        return this.convertYopSdkConfig(this.loadSdkConfig(""));
    }

    public YopFileSdkConfig loadSdkConfig(String appKey) {
        if (!this.sdkConfigs.containsKey(appKey = (String)StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)"default"))) {
            this.sdkConfigs.computeIfAbsent(appKey, k -> this.doLoadYopFileSdkConfig((String)k));
        }
        return this.sdkConfigs.get(appKey);
    }

    private YopFileSdkConfig doLoadYopFileSdkConfig(String appKey) {
        String configDir = System.getProperty(SDK_CONFIG_DIR_PROPERTY_KEY);
        if (StringUtils.isNotEmpty((CharSequence)configDir)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.dir\uff0c\u503c\u4e3a\uff1a{}", (Object)configDir);
        } else {
            configDir = SDK_CONFIG_DIR;
        }
        String env = System.getProperty(SDK_CONFIG_ENV_PROPERTY_KEY);
        if (StringUtils.isNotEmpty((CharSequence)env)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.env\uff0c\u503c\u4e3a\uff1a{}", (Object)env);
            configDir = configDir + "/" + env;
        }
        String configFile = "";
        String file = System.getProperty(SDK_CONFIG_FILE_PROPERTY_KEY);
        if (StringUtils.isNotEmpty((CharSequence)file)) {
            this.logger.info("\u6307\u5b9a\u4e86-Dyop.sdk.config.file\uff0c\u503c\u4e3a\uff1a{}", (Object)file);
            configFile = !StringUtils.startsWithAny((CharSequence)file, (CharSequence[])new CharSequence[]{"file://"}) ? configDir + "/" + file : file;
        } else {
            configFile = configDir + "/yop_sdk_config_" + appKey + ".json";
        }
        this.logger.info("\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6{}", (Object)configFile);
        YopFileSdkConfig customSdkConfig = this.loadSdkConfigFile(configFile);
        if (!StringUtils.equals((CharSequence)DEFAULT_CONFIG_FILE, (CharSequence)configFile)) {
            YopFileSdkConfig defaultConfig = this.loadSdkConfigFile(DEFAULT_CONFIG_FILE);
            customSdkConfig = this.fillNullConfig(defaultConfig, customSdkConfig);
        }
        if (null == customSdkConfig) {
            throw new YopClientException("Can't load config, file:" + configFile);
        }
        return customSdkConfig;
    }

    private YopFileSdkConfig fillNullConfig(YopFileSdkConfig sourceBean, YopFileSdkConfig targetBean) {
        if (null == sourceBean) {
            return targetBean;
        }
        if (null == targetBean) {
            return sourceBean;
        }
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = targetBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field targetField;
            Field sourceField = sourceFields[i];
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic((targetField = targetFields[i]).getModifiers())) continue;
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (sourceField.get(sourceBean) == null || "serialVersionUID".equals(sourceField.getName()) || targetField.get(targetBean) != null) continue;
                targetField.set(targetBean, sourceField.get(sourceBean));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return targetBean;
    }

    private YopFileSdkConfig loadSdkConfigFile(String configFile) {
        YopFileSdkConfig sdkConfig = null;
        try {
            if (!StringUtils.startsWithAny((CharSequence)configFile, (CharSequence[])new CharSequence[]{"file://"})) {
                configFile = "classpath*:" + configFile;
            }
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(configFile);
            for (int i = resources.length - 1; i >= 0; --i) {
                Resource resource = resources[i];
                StringBuilder script = new StringBuilder();
                try (InputStreamReader isr = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                     BufferedReader bufferReader = new BufferedReader(isr);){
                    String tempString;
                    while ((tempString = bufferReader.readLine()) != null) {
                        script.append(tempString).append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (script.length() <= 0) continue;
                YopFileSdkConfig sdkConfig0 = JsonUtils.loadFrom(script.toString(), YopFileSdkConfig.class);
                sdkConfig = BeanUtils.merge(sdkConfig0, sdkConfig);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sdkConfig;
    }

    private YopSdkConfig convertYopSdkConfig(YopFileSdkConfig yopFileSdkConfig) {
        YopSdkConfig yopSdkConfig = new YopSdkConfig();
        yopSdkConfig.setServerRoot(yopFileSdkConfig.getServerRoot());
        yopSdkConfig.setYosServerRoot(yopFileSdkConfig.getYosServerRoot());
        yopSdkConfig.setSandboxServerRoot(yopFileSdkConfig.getSandboxServerRoot());
        yopSdkConfig.setTrustAllCerts(yopFileSdkConfig.getTrustAllCerts());
        yopSdkConfig.setProxy(yopFileSdkConfig.getProxy());
        yopSdkConfig.setRegion(yopFileSdkConfig.getRegion());
        yopSdkConfig.setYopHttpClientConfig(yopFileSdkConfig.getHttpClient());
        yopSdkConfig.storeYopPublicKey(yopFileSdkConfig.getYopPublicKey());
        yopSdkConfig.setYopCertStore(yopFileSdkConfig.getYopCertStore());
        return yopSdkConfig;
    }

    public Map<String, YopFileSdkConfig> getSdkConfigs() {
        return this.sdkConfigs;
    }

    @Override
    public void removeConfig(String key) {
        this.sdkConfigs.remove(key);
    }
}

