/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.provider.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertStore;
import com.yeepay.yop.sdk.config.provider.file.YopHttpClientConfig;
import com.yeepay.yop.sdk.config.provider.file.YopProxyConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class YopFileSdkConfig
implements Serializable {
    private static final long serialVersionUID = 2181419124446854272L;
    @JsonProperty(value="app_key")
    private String appKey;
    @JsonProperty(value="server_root")
    private String serverRoot;
    @JsonProperty(value="yos_server_root")
    private String yosServerRoot;
    @JsonProperty(value="sandbox_server_root")
    private String sandboxServerRoot;
    @JsonProperty(value="aes_secret_key")
    private String aesSecretKey;
    @JsonProperty(value="yop_public_key")
    private YopCertConfig[] yopPublicKey;
    private Map<String, List<YopCertConfig>> isvPrivateKeyMap;
    @Deprecated
    @JsonProperty(value="encrypt_key")
    private String encryptKey;
    @JsonProperty(value="http_client")
    private YopHttpClientConfig httpClient;
    @JsonProperty(value="trust_all_certs")
    private Boolean trustAllCerts;
    private YopProxyConfig proxy;
    private String region;
    @JsonProperty(value="yop_cert_store")
    private YopCertStore yopCertStore;
    private Map<String, List<YopCertConfig>> isvEncryptKeyMap;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public String getYosServerRoot() {
        return this.yosServerRoot;
    }

    public void setYosServerRoot(String yosServerRoot) {
        this.yosServerRoot = yosServerRoot;
    }

    public String getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }

    public void setSandboxServerRoot(String sandboxServerRoot) {
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public String getAesSecretKey() {
        return this.aesSecretKey;
    }

    public void setAesSecretKey(String aesSecretKey) {
        this.aesSecretKey = aesSecretKey;
    }

    public YopCertConfig[] getYopPublicKey() {
        return this.yopPublicKey;
    }

    public void setYopPublicKey(YopCertConfig[] yopPublicKey) {
        this.yopPublicKey = yopPublicKey;
    }

    public List<YopCertConfig> getIsvPrivateKey(String appKey) {
        if (null == this.isvPrivateKeyMap) {
            return Collections.emptyList();
        }
        return this.isvPrivateKeyMap.get(appKey);
    }

    @JsonProperty(value="isv_private_key")
    public void setIsvPrivateKey(YopCertConfig[] isvPrivateKeys) {
        if (null == this.isvPrivateKeyMap) {
            this.isvPrivateKeyMap = new HashMap<String, List<YopCertConfig>>(16);
        }
        for (final YopCertConfig isvPrivateKey : isvPrivateKeys) {
            String appKey = StringUtils.defaultString((String)isvPrivateKey.getAppKey(), (String)this.getAppKey());
            if (this.isvPrivateKeyMap.containsKey(appKey)) {
                this.isvPrivateKeyMap.get(appKey).add(isvPrivateKey);
                continue;
            }
            this.isvPrivateKeyMap.put(appKey, (List<YopCertConfig>)new LinkedList<YopCertConfig>(){
                {
                    this.add(isvPrivateKey);
                }
            });
        }
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public YopHttpClientConfig getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(YopHttpClientConfig httpClient) {
        this.httpClient = httpClient;
    }

    public Boolean getTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(Boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public YopProxyConfig getProxy() {
        return this.proxy;
    }

    public void setProxy(YopProxyConfig proxy) {
        this.proxy = proxy;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public YopCertStore getYopCertStore() {
        return this.yopCertStore;
    }

    public void setYopCertStore(YopCertStore yopCertStore) {
        this.yopCertStore = yopCertStore;
    }

    public List<YopCertConfig> getIsvEncryptKey(String appKey) {
        if (null == this.isvEncryptKeyMap) {
            return Collections.emptyList();
        }
        return this.isvEncryptKeyMap.get(appKey);
    }

    @JsonProperty(value="isv_encrypt_key")
    public void setIsvEncryptKey(YopCertConfig[] isvEncryptKeys) {
        if (null == this.isvEncryptKeyMap) {
            this.isvEncryptKeyMap = new HashMap<String, List<YopCertConfig>>(16);
        }
        for (final YopCertConfig isvEncryptKey : isvEncryptKeys) {
            String appKey = StringUtils.defaultString((String)isvEncryptKey.getAppKey(), (String)this.getAppKey());
            if (this.isvEncryptKeyMap.containsKey(appKey)) {
                this.isvEncryptKeyMap.get(appKey).add(isvEncryptKey);
                continue;
            }
            this.isvEncryptKeyMap.put(appKey, (List<YopCertConfig>)new LinkedList<YopCertConfig>(){
                {
                    this.add(isvEncryptKey);
                }
            });
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

