/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.config.provider.file.YopFileSdkConfig;
import com.yeepay.yop.sdk.config.provider.file.support.YopCertConfigUtils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class YopAppConfig
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String appKey;
    private String aesSecretKey;
    private String encryptKey;
    private Map<CertTypeEnum, String> isvPrivateKeys = Maps.newHashMap();
    private List<YopCertConfig> isvEncryptKeys = Lists.newLinkedList();

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAesSecretKey() {
        return this.aesSecretKey;
    }

    public void setAesSecretKey(String aesSecretKey) {
        this.aesSecretKey = aesSecretKey;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public void setIsvPrivateKey(List<YopCertConfig> isvPrivateKeys) {
        if (CollectionUtils.isEmpty(isvPrivateKeys)) {
            return;
        }
        for (YopCertConfig isvPrivateKey : isvPrivateKeys) {
            this.isvPrivateKeys.put(isvPrivateKey.getCertType(), YopCertConfigUtils.loadPrivateKey(isvPrivateKey));
        }
    }

    public Map<CertTypeEnum, String> getIsvPrivateKeys() {
        return this.isvPrivateKeys;
    }

    public String loadPrivateKey(CertTypeEnum certType) {
        return this.isvPrivateKeys.get((Object)certType);
    }

    public List<YopCertConfig> getIsvEncryptKey() {
        return this.isvEncryptKeys;
    }

    public void setIsvEncryptKeyList(List<YopCertConfig> isvEncryptKeyList) {
        this.isvEncryptKeys = isvEncryptKeyList;
    }

    public static final class Builder {
        private String appKey;
        private List<YopCertConfig> isvPrivateKeys;
        private List<YopCertConfig> isvEncryptKeys;
        private YopFileSdkConfig yopFileSdkConfig;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder withIsvPrivateKeys(List<YopCertConfig> isvPrivateKeys) {
            this.isvPrivateKeys = isvPrivateKeys;
            return this;
        }

        public Builder withIsvEncryptKeys(List<YopCertConfig> isvEncryptKeys) {
            this.isvEncryptKeys = isvEncryptKeys;
            return this;
        }

        public Builder withSDKConfig(YopFileSdkConfig yopFileSdkConfig) {
            this.yopFileSdkConfig = yopFileSdkConfig;
            return this;
        }

        public YopAppConfig build() {
            if (null == this.appKey) {
                this.appKey = this.yopFileSdkConfig.getAppKey();
            }
            YopAppConfig yopAppConfig = new YopAppConfig();
            yopAppConfig.setAppKey(this.appKey);
            yopAppConfig.setEncryptKey(this.yopFileSdkConfig.getEncryptKey());
            if (CollectionUtils.isEmpty(this.isvPrivateKeys)) {
                this.isvPrivateKeys = this.yopFileSdkConfig.getIsvPrivateKey(this.appKey);
            }
            yopAppConfig.setIsvPrivateKey(this.isvPrivateKeys);
            if (CollectionUtils.isEmpty(this.isvEncryptKeys)) {
                this.isvEncryptKeys = this.yopFileSdkConfig.getIsvEncryptKey(this.appKey);
            }
            yopAppConfig.setIsvEncryptKeyList(this.isvEncryptKeys);
            return yopAppConfig;
        }
    }
}

