/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqSupport;
import com.yeepay.yop.sdk.auth.signer.YopSignerFactory;
import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.client.router.SimpleGateWayRouter;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpClientFactory;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ClientHandlerImpl
implements ClientHandler {
    private final YopCredentialsProvider yopCredentialsProvider;
    private final AuthorizationReqRegistry authorizationReqRegistry;
    private final YopHttpClient client;
    private final GateWayRouter gateWayRouter;

    public ClientHandlerImpl(ClientHandlerParams handlerParams) {
        this.yopCredentialsProvider = handlerParams.getClientParams().getCredentialsProvider();
        this.authorizationReqRegistry = handlerParams.getClientParams().getAuthorizationReqRegistry();
        ServerRootSpace serverRootSpace = new ServerRootSpace(handlerParams.getClientParams().getEndPoint(), handlerParams.getClientParams().getYosEndPoint(), handlerParams.getClientParams().getSandboxEndPoint());
        this.gateWayRouter = new SimpleGateWayRouter(serverRootSpace);
        this.client = this.buildHttpClient(handlerParams);
    }

    private YopHttpClient buildHttpClient(ClientHandlerParams handlerParams) {
        YopHttpClient yopHttpClient = null == handlerParams ? YopHttpClientFactory.getDefaultClient() : YopHttpClientFactory.getClient(handlerParams.getClientParams().getClientConfiguration());
        return yopHttpClient;
    }

    @Override
    public <Input extends BaseRequest, Output extends BaseResponse> Output execute(ClientExecutionParams<Input, Output> executionParams) {
        Input input = executionParams.getInput();
        ExecutionContext executionContext = this.getExecutionContext(executionParams);
        Request<Input> request = executionParams.getRequestMarshaller().marshall(input);
        request.setEndpoint(this.gateWayRouter.route(executionContext.getYopCredentials().getAppKey(), request));
        return this.client.execute(request, ((BaseRequest)request.getOriginalRequestObject()).getRequestConfig(), executionContext, executionParams.getResponseHandler());
    }

    private <Output extends BaseResponse, Input extends BaseRequest> ExecutionContext getExecutionContext(ClientExecutionParams<Input, Output> executionParams) {
        AuthorizationReq authorizationReq = this.getAuthorizationReq(executionParams.getInput());
        if (authorizationReq == null) {
            throw new YopClientException("no authenticate req defined");
        }
        ExecutionContext.Builder builder = ExecutionContext.Builder.anExecutionContext().withSigner(YopSignerFactory.getSigner(authorizationReq.getSignerType())).withSignOptions(authorizationReq.getSignOptions());
        YopCredentials credential = ((BaseRequest)executionParams.getInput()).getRequestConfig().getCredentials();
        String appKey = ((BaseRequest)executionParams.getInput()).getRequestConfig().getAppKey();
        if (credential == null) {
            credential = this.yopCredentialsProvider.getCredentials(appKey, authorizationReq.getCredentialType());
        }
        if (credential == null) {
            throw new YopClientException("No credentials specified");
        }
        builder.withYopCredentials(credential);
        return builder.build();
    }

    private <Input extends BaseRequest> AuthorizationReq getAuthorizationReq(Input input) {
        String customSecurityReq;
        String appKey = input.getRequestConfig().getAppKey();
        String string = customSecurityReq = input.getRequestConfig() == null ? null : input.getRequestConfig().getSecurityReq();
        if (StringUtils.isNotEmpty((CharSequence)customSecurityReq)) {
            AuthorizationReq authorizationReq = AuthorizationReqSupport.getAuthorizationReq(customSecurityReq);
            if (authorizationReq == null) {
                throw new YopClientException("unsupported customSecurityReq:" + customSecurityReq);
            }
            return authorizationReq;
        }
        List<CertTypeEnum> supportCertType = this.yopCredentialsProvider.getSupportCertTypes(appKey);
        List<AuthorizationReq> authorizationReqs = this.authorizationReqRegistry.getAuthorizationReq(input.getOperationId());
        for (AuthorizationReq authorizationReq : authorizationReqs) {
            if (!supportCertType.contains((Object)CertTypeEnum.parse(authorizationReq.getCredentialType()))) continue;
            return authorizationReq;
        }
        throw new YopClientException("can not find private key");
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }
}

