/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer.process;

import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.utils.Sm2Utils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class YopSm2SignProcessor
implements YopSignProcessor {
    @Override
    public String doSign(String content, CredentialsItem credentialsItem) {
        PKICredentialsItem pkiCredentialsItem = (PKICredentialsItem)credentialsItem;
        return Sm2Utils.sign(content, (BCECPrivateKey)pkiCredentialsItem.getPrivateKey());
    }

    @Override
    public boolean doVerify(String content, String signature, CredentialsItem credentialsItem) {
        PKICredentialsItem pkiCredentialsItem = (PKICredentialsItem)credentialsItem;
        return Sm2Utils.verifySign(content, signature, (BCECPublicKey)pkiCredentialsItem.getPublicKey());
    }

    @Override
    public boolean isSupport(CredentialsItem credentialsItem) {
        return credentialsItem instanceof PKICredentialsItem;
    }

    @Override
    public String name() {
        return "SM2";
    }

    @Override
    public String getDigestAlg() {
        return DigestAlgEnum.SM3.name();
    }
}

