/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer.process;

import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.exception.YopClientException;

public interface YopSignProcessor {
    default public String sign(String content, CredentialsItem credentialsItem) {
        if (!this.isSupport(credentialsItem)) {
            throw new YopClientException("UnSupported credentialsItem type:" + credentialsItem.getClass().getSimpleName());
        }
        return this.doSign(content, credentialsItem);
    }

    public String doSign(String var1, CredentialsItem var2);

    default public boolean verify(String content, String signature, CredentialsItem credentialsItem) {
        if (this.isSupport(credentialsItem)) {
            return this.doVerify(content, signature, credentialsItem);
        }
        throw new YopClientException("UnSupported credentialsItem type:" + credentialsItem.getClass().getSimpleName());
    }

    public boolean doVerify(String var1, String var2, CredentialsItem var3);

    public boolean isSupport(CredentialsItem var1);

    public String name();

    public String getDigestAlg();
}

