/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopCredentialsWithoutSign;
import com.yeepay.yop.sdk.auth.signer.YopSigner;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import com.yeepay.yop.sdk.utils.DateUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopPKISigner
implements YopSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopPKISigner.class);
    private static final ThreadLocal<Map<DigestAlgEnum, MessageDigest>> MESSAGE_DIGEST;
    private static final String YOP_PROTOCOL_VERSION = "yop-auth-v3";
    private static final Set<String> defaultHeadersToSign;
    private static final Joiner headerJoiner;
    private static final Joiner signedHeaderStringJoiner;

    @Override
    public List<String> supportSignerAlg() {
        return Lists.newArrayList((Object[])new String[]{SignerTypeEnum.SM2.name(), SignerTypeEnum.RSA.name()});
    }

    @Override
    public void sign(Request<? extends BaseRequest> request, YopCredentials credentials, SignOptions options) {
        Preconditions.checkNotNull(request, (Object)"request should not be null.");
        if (credentials == null || credentials instanceof YopCredentialsWithoutSign) {
            return;
        }
        String authString = this.buildAuthString(credentials, options);
        LOGGER.debug("authString:{}", (Object)authString);
        this.additionalHeader(request, options);
        SortedMap<String, String> headersToSign = this.getHeadersToSign(request.getHeaders(), defaultHeadersToSign);
        String canonicalRequest = this.buildCanonicalRequest(request, authString, headersToSign);
        LOGGER.debug("canonicalRequest:{}", (Object)canonicalRequest.replace("\n", "[\\n]"));
        CredentialsItem credentialsItem = (CredentialsItem)credentials.getCredential();
        YopSignProcessor yopSignProcessor = YopSignProcessorFactory.getSignProcessor(credentialsItem.getCertType().name());
        String signature = yopSignProcessor.sign(canonicalRequest, credentialsItem) + "$" + yopSignProcessor.getDigestAlg();
        LOGGER.debug("signature:{}", (Object)signature);
        String authorizationHeader = this.buildAuthzHeader(options, authString, headersToSign, signature);
        LOGGER.debug("Authorization:{}", (Object)authorizationHeader);
        request.addHeader("Authorization", authorizationHeader);
    }

    private void additionalHeader(Request<? extends BaseRequest> request, SignOptions options) {
        request.addHeader("Host", HttpUtils.generateHostHeader(request.getEndpoint()));
        DigestAlgEnum digestAlg = options.getDigestAlg();
        String contentHash = this.calculateContentHash(request, digestAlg);
        request.addHeader(this.getDigestAlgHeaderName(digestAlg), contentHash);
    }

    private String buildAuthString(YopCredentials credentials, SignOptions options) {
        String appKey = credentials.getAppKey();
        Date timestamp = new Date();
        return "yop-auth-v3/" + appKey + "/" + DateUtils.formatAlternateIso8601Date(timestamp) + "/" + options.getExpirationInSeconds();
    }

    private String buildCanonicalRequest(Request<? extends BaseRequest> request, String authString, SortedMap<String, String> headersToSign) {
        String canonicalQueryString = this.getCanonicalQueryString(request);
        String canonicalHeaders = this.getCanonicalHeaders(headersToSign);
        String apiUri = request.getResourcePath();
        String canonicalURI = this.getCanonicalURIPath(apiUri);
        return authString + "\n" + (Object)((Object)request.getHttpMethod()) + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeaders;
    }

    private String buildAuthzHeader(SignOptions options, String authString, SortedMap<String, String> headersToSign, String signature) {
        String signedHeaders = signedHeaderStringJoiner.join(headersToSign.keySet());
        signedHeaders = signedHeaders.trim().toLowerCase();
        return options.getProtocolPrefix() + " " + authString + "/" + signedHeaders + "/" + signature;
    }

    private String getCanonicalQueryString(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return HttpUtils.getCanonicalQueryString(request.getParameters(), true);
    }

    private String getDigestAlgHeaderName(DigestAlgEnum digestAlgEnum) {
        if (DigestAlgEnum.SM3 == digestAlgEnum) {
            return "x-yop-content-sm3";
        }
        return "x-yop-content-sha256";
    }

    private String calculateContentHash(Request<? extends BaseRequest> request, DigestAlgEnum digestAlg) {
        RestartableInputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        String contentHash = Encodes.encodeHex(this.hash(payloadStream, digestAlg));
        payloadStream.restart();
        return contentHash;
    }

    private byte[] hash(InputStream input, DigestAlgEnum digestAlg) {
        try {
            MessageDigest md = YopPKISigner.getMessageDigestInstance(digestAlg);
            DigestInputStream digestInputStream = new DigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new YopClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private RestartableInputStream getBinaryRequestPayloadStream(Request<? extends BaseRequest> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.getCanonicalQueryString(request.getParameters(), true);
            if (StringUtils.isEmpty((CharSequence)encodedParameters)) {
                return RestartableInputStream.wrap(new byte[0]);
            }
            return RestartableInputStream.wrap(encodedParameters.getBytes(YopConstants.DEFAULT_CHARSET));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    private RestartableInputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<? extends BaseRequest> request) {
        if (request.getContent() instanceof RestartableInputStream) {
            return (RestartableInputStream)request.getContent();
        }
        return RestartableInputStream.wrap(new byte[0]);
    }

    private String getCanonicalURIPath(String path) {
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            return HttpUtils.normalizePath(path);
        }
        return "/" + HttpUtils.normalizePath(path);
    }

    private SortedMap<String, String> getHeadersToSign(Map<String, String> headers, Set<String> headersToSign) {
        TreeMap ret = Maps.newTreeMap();
        if (headersToSign != null) {
            HashSet tempSet = Sets.newHashSet();
            for (String header : headersToSign) {
                tempSet.add(header.trim().toLowerCase());
            }
            headersToSign = tempSet;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() == null || entry.getValue().isEmpty() || headersToSign == null || !headersToSign.contains(key.toLowerCase()) || "Authorization".equalsIgnoreCase(key)) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    private String getCanonicalHeaders(SortedMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        ArrayList headerStrings = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            headerStrings.add(HttpUtils.normalize(key.trim().toLowerCase()) + ':' + HttpUtils.normalize(value.trim()));
        }
        Collections.sort(headerStrings);
        return headerJoiner.join((Iterable)headerStrings);
    }

    private static MessageDigest getMessageDigestInstance(DigestAlgEnum digestAlg) {
        MessageDigest messageDigest = MESSAGE_DIGEST.get().get((Object)digestAlg);
        messageDigest.reset();
        return messageDigest;
    }

    static {
        defaultHeadersToSign = Sets.newHashSet();
        headerJoiner = Joiner.on((char)'\n');
        signedHeaderStringJoiner = Joiner.on((char)';');
        defaultHeadersToSign.add("Content-Length".toLowerCase());
        defaultHeadersToSign.add("Content-Type".toLowerCase());
        defaultHeadersToSign.add("Content-MD5".toLowerCase());
        defaultHeadersToSign.add("x-yop-request-id");
        defaultHeadersToSign.add("x-yop-date");
        defaultHeadersToSign.add("x-yop-appkey");
        defaultHeadersToSign.add("x-yop-content-sha256");
        defaultHeadersToSign.add("x-yop-hash-crc64ecma");
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        MESSAGE_DIGEST = new ThreadLocal<Map<DigestAlgEnum, MessageDigest>>(){

            @Override
            protected Map<DigestAlgEnum, MessageDigest> initialValue() {
                try {
                    HashMap<DigestAlgEnum, MessageDigest> messageDigestMap = new HashMap<DigestAlgEnum, MessageDigest>(3);
                    messageDigestMap.put(DigestAlgEnum.SM3, MessageDigest.getInstance("SM3", "BC"));
                    messageDigestMap.put(DigestAlgEnum.SHA256, MessageDigest.getInstance("SHA-256"));
                    return messageDigestMap;
                }
                catch (GeneralSecurityException e) {
                    throw new YopClientException("Unable to get Digest Function" + e.getMessage(), e);
                }
            }
        };
    }
}

