/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.req;

import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationReqSupport {
    private static final Map<String, AuthorizationReq> supportedAuthorizationReqs = new HashMap<String, AuthorizationReq>();

    public static AuthorizationReq getAuthorizationReq(String securityReq) {
        return supportedAuthorizationReqs.get(securityReq);
    }

    static {
        supportedAuthorizationReqs.put("YOP-SM2-SM3", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.SM2).withCredentialType("SM2").withSignatureAlg("SM3withSM2").withDigestAlg(DigestAlgEnum.SM3).withProtocolPrefix("YOP-SM2-SM3").build());
        supportedAuthorizationReqs.put("YOP-RSA2048-SHA256", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.RSA).withCredentialType("RSA2048").withSignatureAlg("SHA256withRSA").withDigestAlg(DigestAlgEnum.SHA256).withProtocolPrefix("YOP-RSA2048-SHA256").build());
        supportedAuthorizationReqs.put("YOP-RSA2048-SHA512", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.RSA).withCredentialType("RSA2048").withSignatureAlg("SHA512withRSA").withDigestAlg(DigestAlgEnum.SHA512).withProtocolPrefix("YOP-RSA2048-SHA512").build());
        supportedAuthorizationReqs.put("YOP-RSA4096-SHA256", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.RSA).withCredentialType("RSA4096").withSignatureAlg("SHA256withRSA").withDigestAlg(DigestAlgEnum.SHA256).withProtocolPrefix("YOP-RSA4096-SHA256").build());
        supportedAuthorizationReqs.put("YOP-RSA4096-SHA512", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.RSA).withCredentialType("RSA4096").withSignatureAlg("SHA512withRSA").withDigestAlg(DigestAlgEnum.SHA512).withProtocolPrefix("YOP-RSA4096-SHA512").build());
        supportedAuthorizationReqs.put("YOP-OAUTH2", AuthorizationReq.Builder.anAuthorizationReq().withSignerType(SignerTypeEnum.OAUTH2).withCredentialType("TOKEN").withDigestAlg(DigestAlgEnum.SHA256).withProtocolPrefix("Bearer").build());
    }
}

